/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron;

import com.appdynamics.voltron.LifecycleException;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLifecycleModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(AppLifecycleModule.class);
    private final Object $lock = new Object[0];
    private static final Set<Class<? extends Annotation>> LIFECYCLE_ANNOTATIONS = ImmutableSet.of(PreDestroy.class, PostConstruct.class);
    private final LoadingCache<Class<?>, Multimap<Class<? extends Annotation>, Method>> annotatedMethodsCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Class<?>, Multimap<Class<? extends Annotation>, Method>>(){

        public Multimap<Class<? extends Annotation>, Method> load(Class<?> key) {
            HashMultimap map = HashMultimap.create((int)LIFECYCLE_ANNOTATIONS.size(), (int)1);
            for (Class<? extends Annotation> annotation : LIFECYCLE_ANNOTATIONS) {
                Set methods = ReflectionUtils.getAllMethods(key, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(annotation)});
                if (methods.size() <= 0) continue;
                map.putAll(annotation, (Iterable)methods);
            }
            return map;
        }
    });
    private final Deque<Object> preDestroyObjects = new LinkedBlockingDeque<Object>();
    private volatile boolean stopped = false;
    private Provider<Injector> injector;

    protected void configure() {
        this.injector = this.getProvider(Injector.class);
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                AppLifecycleModule.this.processTypeEncounter(type, encounter);
            }
        });
    }

    private void processTypeEncounter(TypeLiteral<?> type, TypeEncounter<?> encounter) {
        log.trace("Encountered type {}", type);
        Multimap lifecycleMethods = null;
        try {
            lifecycleMethods = (Multimap)this.annotatedMethodsCache.getUnchecked((Object)type.getRawType());
        }
        catch (UncheckedExecutionException e) {
            encounter.addError(e.getCause());
        }
        if (lifecycleMethods != null && !Sets.intersection((Set)lifecycleMethods.keySet(), LIFECYCLE_ANNOTATIONS).isEmpty()) {
            final Provider injectorProvider = encounter.getProvider(Injector.class);
            encounter.register((InjectionListener)new InjectionListener<Object>(){

                public void afterInjection(Object injectee) {
                    AppLifecycleModule.this.processInjectee((Provider<Injector>)injectorProvider, injectee);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInjectee(Provider<Injector> injectorProvider, Object injectee) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.stopped) {
                throw new LifecycleException("Lifecycle management is stopping. Cannot create any more objects.");
            }
            if (injectee == null) {
                return;
            }
            Injector injectorUsed = (Injector)injectorProvider.get();
            Injector ourInjector = (Injector)this.injector.get();
            if (!ourInjector.equals(injectorUsed)) {
                log.trace("Not injecting instance that's not ours.");
                return;
            }
            log.trace("Injecting object {}", injectee);
            Multimap lifecycleMethods = (Multimap)this.annotatedMethodsCache.getUnchecked(injectee.getClass());
            this.callAnnotatedMethods((Multimap<Class<? extends Annotation>, Method>)lifecycleMethods, PostConstruct.class, injectee);
            Collection stopMethods = lifecycleMethods.get(PreDestroy.class);
            if (stopMethods.size() > 0) {
                this.preDestroyObjects.addFirst(injectee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.stopped) {
                log.debug("Called stop() more than once");
                return;
            }
            this.stopped = true;
            for (Object obj : this.preDestroyObjects) {
                Multimap lifecycleMethods = (Multimap)this.annotatedMethodsCache.getUnchecked(obj.getClass());
                this.callAnnotatedMethods((Multimap<Class<? extends Annotation>, Method>)lifecycleMethods, PreDestroy.class, obj);
            }
            this.preDestroyObjects.clear();
        }
    }

    private void callAnnotatedMethods(Multimap<Class<? extends Annotation>, Method> lifecycleMethods, Class<? extends Annotation> annotation, Object target) {
        Collection methods = lifecycleMethods.get(annotation);
        for (Method method : methods) {
            method.setAccessible(true);
            try {
                method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String msg = "Could not invoke " + annotation.getSimpleName() + "-annotated method on " + String.valueOf(target);
                log.error(msg, (Throwable)e);
                throw new LifecycleException(msg, e);
            }
        }
    }
}

