/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.shared.rest.client.eventservice;

import com.appdynamics.analytics.client.common.AbstractAnalyticsClient;
import com.appdynamics.analytics.client.common.DropwizardClient;
import com.appdynamics.analytics.client.common.HttpEntityEnclosingRequestBuilder;
import com.appdynamics.analytics.client.common.HttpRequestBuilder;
import com.appdynamics.analytics.client.common.Response;
import com.appdynamics.analytics.client.common.RestClientUtils;
import com.appdynamics.analytics.client.common.SyncResponse;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.shared.rest.client.eventservice.EventServiceClient;
import com.appdynamics.analytics.shared.rest.client.eventservice.creator.EventTypeCreator;
import com.appdynamics.analytics.shared.rest.client.utils.AccountNameEventTypeKey;
import com.appdynamics.analytics.shared.rest.dto.DeleteEventsRequest;
import com.appdynamics.analytics.shared.rest.dto.HiddenField;
import com.appdynamics.analytics.shared.rest.dto.MoveEventsRequest;
import com.appdynamics.analytics.shared.rest.dto.asyncjob.AsyncJobResponse;
import com.appdynamics.analytics.shared.rest.dto.asyncjob.AsynchronousEventTypeUpdateResponse;
import com.appdynamics.analytics.shared.rest.exceptions.StandardErrorSubStatusCodes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventServiceClient
extends DropwizardClient
implements EventServiceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEventServiceClient.class);
    private static final String BASE_URI = "/v3/events";
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private final Set<EventTypeCreator> eventTypeCreators = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AccountNameEventTypeKey> createdOrUpdatedEventTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AccountNameEventTypeKey> eventTypesWithoutCreators = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ThreadLocal<AccountNameEventTypeKey> tlsAccountNameEventTypeKey = new ThreadLocal<AccountNameEventTypeKey>(){

        @Override
        protected AccountNameEventTypeKey initialValue() {
            return new AccountNameEventTypeKey("", "");
        }
    };

    public DefaultEventServiceClient(ObjectMapper mapper, CloseableHttpClient client, URI baseUri) {
        super(mapper, client, baseUri);
    }

    public static AbstractAnalyticsClient.Builder<DefaultEventServiceClient> builder(String scheme, String host, int port) {
        return AbstractAnalyticsClient.builder(DefaultEventServiceClient.class, (String)scheme, (String)host, (int)port).basePath(BASE_URI);
    }

    public static AbstractAnalyticsClient.Builder<DefaultEventServiceClient> builder(String scheme, String host, int port, String subDomain) {
        if (subDomain == null || subDomain.isEmpty()) {
            return DefaultEventServiceClient.builder(scheme, host, port);
        }
        log.debug("event service subdomain provided: [{}]", (Object)subDomain);
        return AbstractAnalyticsClient.builder(DefaultEventServiceClient.class, (String)scheme, (String)host, (int)port).basePath(subDomain + BASE_URI);
    }

    @Override
    public Response<Void> registerEventType(String accountName, String accessKey, String eventType, String body) throws RestException {
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(200)).executeAndReturnRawResponseString();
        return new SyncResponse();
    }

    @Override
    public Response<Void> updateEventType(String accountName, String accessKey, String eventType, String body) throws RestException {
        try {
            ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().put().appendPath(eventType, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
        return new SyncResponse();
    }

    @Override
    public AsynchronousEventTypeUpdateResponse bulkUpdateEventType(String accountName, String accessKey, String eventType, int timeout, String body) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accountName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)eventType));
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"Timeout parameter must be greater than zero.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)body));
        CloseableHttpResponse response = ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().put().appendPath(eventType, new String[0])).appendPath("_bulk", new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).executeAndReturnRawResponse();
        int expectedStatusCode = response.getStatusLine().getStatusCode() == 200 ? 200 : 202;
        return (AsynchronousEventTypeUpdateResponse)RestClientUtils.resolve((HttpResponse)response, (int)expectedStatusCode, (ObjectMapper)this.getMapper(), AsynchronousEventTypeUpdateResponse.class);
    }

    @Override
    public AsynchronousEventTypeUpdateResponse bulkUpdateEventTypeStatus(String accountName, String accessKey, String eventType, String guid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accountName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)eventType));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)guid));
        return (AsynchronousEventTypeUpdateResponse)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[0])).appendPath("_bulk", new String[0])).appendPath(guid, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).execute(AsynchronousEventTypeUpdateResponse.class);
    }

    @Override
    public String getEventType(String accountName, String accessKey, String eventType) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            return ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 401) {
                this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                return null;
            }
            throw e;
        }
    }

    @Override
    public Response<String> getEventType2(final String accountName, final String accessKey, final String eventType) {
        Callable<String> getEventTypeCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.getEventType(accountName, accessKey, eventType);
            }
        };
        return new SyncResponse((Callable)getEventTypeCall);
    }

    @Override
    public String getEventTypeUsageNumDocuments(String accountName, String accessKey, String eventType, String startDateTime, String endDateTime) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            return ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"usage", "documents"})).addQueryParam("startDateTime", startDateTime)).addQueryParam("endDateTime", endDateTime)).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 401) {
                this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                return null;
            }
            throw e;
        }
    }

    @Override
    public Response<String> getEventTypeUsageNumDocuments2(final String accountName, final String accessKey, final String eventType, final String startDateTime, final String endDateTime) {
        Callable<String> getEventTypeUsageNumDocumentsCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.getEventTypeUsageNumDocuments(accountName, accessKey, eventType, startDateTime, endDateTime);
            }
        };
        return new SyncResponse((Callable)getEventTypeUsageNumDocumentsCall);
    }

    @Override
    public String getEventTypeUsageNumDocumentFragments(String accountName, String accessKey, String eventType, String date, int hourOfDay) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            return ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"usage", "documentFragments"})).addQueryParam("date", date)).addQueryParam("hourOfDay", Integer.toString(hourOfDay))).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 401) {
                this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                return null;
            }
            throw e;
        }
    }

    @Override
    public Response<String> getEventTypeUsageNumDocumentFragments2(final String accountName, final String accessKey, final String eventType, final String date, final int hourOfDay) {
        Callable<String> getEventTypeUsageNumFragmentsCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.getEventTypeUsageNumDocumentFragments(accountName, accessKey, eventType, date, hourOfDay);
            }
        };
        return new SyncResponse((Callable)getEventTypeUsageNumFragmentsCall);
    }

    @Override
    public String getEventTypeUsageNumBytes(String accountName, String accessKey, String eventType, String date, int hourOfDay) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            return ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"usage", "bytes"})).addQueryParam("date", date)).addQueryParam("hourOfDay", Integer.toString(hourOfDay))).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 401) {
                this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                return null;
            }
            throw e;
        }
    }

    @Override
    public Response<String> getEventTypeUsageNumBytes2(final String accountName, final String accessKey, final String eventType, final String date, final int hourOfDay) {
        Callable<String> getEventTypeUsageNumBytesCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.getEventTypeUsageNumBytes(accountName, accessKey, eventType, date, hourOfDay);
            }
        };
        return new SyncResponse((Callable)getEventTypeUsageNumBytesCall);
    }

    @Override
    public Response<Void> deleteEventType(String accountName, String accessKey, String eventType) throws RestException {
        block2: {
            try {
                ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().delete().appendPath(eventType, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(204)).executeAndReturnRawResponseString();
                this.invalidateLocalEventTypeCache(accountName, eventType);
            }
            catch (RestException e) {
                if (e.getStatusCode() == 404) break block2;
                throw e;
            }
        }
        return new SyncResponse();
    }

    @Override
    public Response<Void> publishEvents(String accountName, String accessKey, String eventType, String body) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"event"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(202)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
        return new SyncResponse();
    }

    @Override
    public Response<Void> eumPublish(String accountName, String accessKey, String eventType, String body) {
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath("eumPublish", new String[]{eventType})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(202)).executeAndReturnRawResponseString();
        return new SyncResponse();
    }

    @Override
    public Response<Void> upsertEvents(String accountName, String accessKey, String eventType, String body, String idPath, List<String> mergeFields) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().patch().appendPath(eventType, new String[]{"event"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).addQueryParam("_idPath", idPath)).addQueryParam("_mergeFields", COMMA_JOINER.join(mergeFields))).expecting(202)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
        return new SyncResponse();
    }

    @Override
    public String searchEvents(String accountName, String accessKey, String eventType, String searchRequest) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            return ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"search"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)searchRequest).expecting(200)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
    }

    @Override
    public Response<String> searchEvents2(final String accountName, final String accessKey, final String eventType, final String searchRequest) {
        Callable<String> searchEventCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.searchEvents(accountName, accessKey, eventType, searchRequest);
            }
        };
        return new SyncResponse((Callable)searchEventCall);
    }

    @Override
    public Response<Void> moveEvents(String accountName, String accessKey, String eventType, MoveEventsRequest moveEventsRequest) {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"move"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)moveEventsRequest).expecting(204)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
        return new SyncResponse();
    }

    @Override
    public Response<Void> deleteEvents(String accountName, String accessKey, String eventType, DeleteEventsRequest deleteEventsRequest) {
        this.satisfyCreators(accountName, accessKey, eventType);
        try {
            ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"delete"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)deleteEventsRequest).expecting(204)).executeAndReturnRawResponseString();
        }
        catch (RestException e) {
            this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
            throw e;
        }
        return new SyncResponse();
    }

    @Override
    public String multiSearchEvents(String accountName, String accessKey, String multiSearchRequest) throws RestException {
        return ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath("msearch", new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)multiSearchRequest).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<String> multiSearchEvents2(final String accountName, final String accessKey, final String multiSearchRequest) {
        Callable<String> multiSearchEventCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.multiSearchEvents(accountName, accessKey, multiSearchRequest);
            }
        };
        return new SyncResponse((Callable)multiSearchEventCall);
    }

    @Override
    public String multiQueryEvents(String accountName, String accessKey, String multiQueryString, String startTime, String endTime, String limitResults, boolean includeOthers) throws RestException {
        return ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath("mquery", new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)multiQueryString).addQueryParam("start", startTime)).addQueryParam("end", endTime)).addQueryParam("limit", limitResults)).addQueryParam("others", Boolean.toString(includeOthers))).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<String> multiQueryEvents2(final String accountName, final String accessKey, final String multiQueryString, final String startTime, final String endTime, final String limitResults, final boolean others) {
        Callable<String> multiQueryCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.multiQueryEvents(accountName, accessKey, multiQueryString, startTime, endTime, limitResults, others);
            }
        };
        return new SyncResponse((Callable)multiQueryCall);
    }

    @Override
    public void registerEventTypeCreator(EventTypeCreator ... creators) {
        this.eventTypeCreators.addAll(Arrays.asList(creators));
        this.eventTypesWithoutCreators.clear();
    }

    private void satisfyCreators(String accountName, String accessKey, String eventType) {
        AccountNameEventTypeKey key = this.tlsAccountNameEventTypeKey.get();
        key.reuse(accountName, eventType);
        if (this.createdOrUpdatedEventTypes.contains(key) || this.eventTypesWithoutCreators.contains(key)) {
            return;
        }
        EventTypeCreator creator = this.findEventTypeCreator(eventType);
        if (log.isDebugEnabled()) {
            log.debug("Found creator {} for eventType {}", (Object)creator, (Object)eventType);
        }
        if (creator == null) {
            this.eventTypesWithoutCreators.add(key.clone());
            return;
        }
        try {
            log.info("Registering event type {} for account {}", (Object)eventType, (Object)accountName);
            this.registerEventType(accountName, accessKey, eventType, creator.getEventTypeMapping());
            this.createdOrUpdatedEventTypes.add(key.clone());
        }
        catch (RestException e) {
            if (e.getStatusCode() == 409 && Objects.equals(StandardErrorSubStatusCodes.CONFLICT_EVENT_TYPE.getSubStatusCode(), e.getCode())) {
                log.info("Event type already registered, updating event type {} for account {}", (Object)eventType, (Object)accountName);
                this.updateEventType(accountName, accessKey, eventType, creator.getEventTypeMapping());
                this.createdOrUpdatedEventTypes.add(key.clone());
            }
            throw e;
        }
    }

    private EventTypeCreator findEventTypeCreator(String eventType) {
        for (EventTypeCreator creator : this.eventTypeCreators) {
            if (!Objects.equals(creator.getEventTypeName(), eventType)) continue;
            return creator;
        }
        return null;
    }

    @Override
    public String relevantFields(String accountName, String accessKey, String eventType, String significantTermsQuery) throws RestException {
        this.satisfyCreators(accountName, accessKey, eventType);
        return ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"relevantFields"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)significantTermsQuery).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<String> relevantFields2(final String accountName, final String accessKey, final String eventType, final String significantTermsQuery) {
        Callable<String> relevantFieldCall = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DefaultEventServiceClient.this.relevantFields(accountName, accessKey, eventType, significantTermsQuery);
            }
        };
        return new SyncResponse((Callable)relevantFieldCall);
    }

    @Override
    public void ping(String accountName, String accessKey) throws RestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accountName));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessKey));
        ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath("ping", new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public void hideFields(String accountName, String accessKey, String eventType, List<HiddenField> fields) {
        ArrayNode body = this.getMapper().createArrayNode();
        for (HiddenField hiddenField : fields) {
            body.add((JsonNode)this.getMapper().convertValue((Object)hiddenField, JsonNode.class));
        }
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"event", "hiddenFields"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<Void> hideFields2(final String accountName, final String accessKey, final String eventType, final List<HiddenField> fields) {
        Callable<Void> hideFieldCall = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultEventServiceClient.this.hideFields(accountName, accessKey, eventType, fields);
                return null;
            }
        };
        return new SyncResponse((Callable)hideFieldCall);
    }

    private String hiddenFieldsResponse(String eventType, String accountName, String accessKey) {
        return ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().get().appendPath(eventType, new String[]{"event", "hiddenFields"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public List<HiddenField> listHiddenFields(String accountName, String accessKey, String eventType) throws RestException, IOException {
        String response = this.hiddenFieldsResponse(eventType, accountName, accessKey);
        return (List)this.getMapper().readValue(response, (JavaType)this.getMapper().getTypeFactory().constructCollectionType(List.class, HiddenField.class));
    }

    @Override
    public Response<HiddenField[]> listHiddenFields2(final String accountName, final String accessKey, final String eventType) {
        Callable<HiddenField[]> hiddenFieldCall = new Callable<HiddenField[]>(){

            @Override
            public HiddenField[] call() throws Exception {
                String response = DefaultEventServiceClient.this.hiddenFieldsResponse(eventType, accountName, accessKey);
                return (HiddenField[])DefaultEventServiceClient.this.getMapper().readValue(response, HiddenField[].class);
            }
        };
        return new SyncResponse((Callable)hiddenFieldCall);
    }

    @Override
    public void unhideField(String accountName, String accessKey, String eventType, String fieldName) {
        ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.getRequestFactory().delete().appendPath(eventType, new String[]{"event", "hiddenFields", fieldName})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<Void> unhideField2(final String accountName, final String accessKey, final String eventType, final String fieldName) {
        Callable<Void> unhideFieldCall = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultEventServiceClient.this.unhideField(accountName, accessKey, eventType, fieldName);
                return null;
            }
        };
        return new SyncResponse((Callable)unhideFieldCall);
    }

    @Override
    public void unhideFields(String accountName, String accessKey, String eventType, List<String> fieldNames) {
        ArrayNode body = this.getMapper().createArrayNode();
        for (String hiddenField : fieldNames) {
            body.add((JsonNode)this.getMapper().convertValue((Object)hiddenField, JsonNode.class));
        }
        ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(eventType, new String[]{"event", "hiddenFields/_delete"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)body).expecting(200)).executeAndReturnRawResponseString();
    }

    @Override
    public Response<Void> unhideFields2(final String accountName, final String accessKey, final String eventType, final List<String> fieldNames) {
        Callable<Void> unhideFieldCall = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultEventServiceClient.this.unhideFields(accountName, accessKey, eventType, fieldNames);
                return null;
            }
        };
        return new SyncResponse((Callable)unhideFieldCall);
    }

    @Override
    public Response<AsyncJobResponse> deleteByQuery(final String accountName, final String accessKey, final String eventType, final String deleteRequest) throws RestException, IOException {
        Callable<AsyncJobResponse> deleteByQueryCall = new Callable<AsyncJobResponse>(){

            @Override
            public AsyncJobResponse call() throws IOException {
                DefaultEventServiceClient.this.satisfyCreators(accountName, accessKey, eventType);
                try {
                    String response = ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)DefaultEventServiceClient.this.getRequestFactory().post().appendPath(eventType, new String[]{"_deleteByQuery"})).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).setRequestEntity((Object)deleteRequest).expecting(202)).executeAndReturnRawResponseString();
                    return (AsyncJobResponse)DefaultEventServiceClient.this.getMapper().readValue(response, AsyncJobResponse.class);
                }
                catch (RestException e) {
                    DefaultEventServiceClient.this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                    throw e;
                }
            }
        };
        return new SyncResponse((Callable)deleteByQueryCall);
    }

    @Override
    public Response<AsyncJobResponse> deleteByQueryStatus(final String accountName, final String accessKey, final String eventType, final String guid) throws RestException, IOException {
        Callable<AsyncJobResponse> deleteByQueryCall = new Callable<AsyncJobResponse>(){

            @Override
            public AsyncJobResponse call() throws IOException {
                DefaultEventServiceClient.this.satisfyCreators(accountName, accessKey, eventType);
                try {
                    String response = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)DefaultEventServiceClient.this.getRequestFactory().get().appendPath(eventType, new String[]{"_deleteByQuery"})).appendPath(guid, new String[0])).addHeader("Authorization", DefaultEventServiceClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).expecting(200)).executeAndReturnRawResponseString();
                    return (AsyncJobResponse)DefaultEventServiceClient.this.getMapper().readValue(response, AsyncJobResponse.class);
                }
                catch (RestException e) {
                    DefaultEventServiceClient.this.invalidateLocalCacheIfEventTypeNotFound(e, accountName, eventType);
                    throw e;
                }
            }
        };
        return new SyncResponse((Callable)deleteByQueryCall);
    }

    private void invalidateLocalCacheIfEventTypeNotFound(RestException e, String accountName, String eventType) {
        if (e.getStatusCode() == 404 && Objects.equals(StandardErrorSubStatusCodes.MISSING_EVENT_TYPE.getSubStatusCode(), e.getCode())) {
            this.invalidateLocalEventTypeCache(accountName, eventType);
        }
    }

    private void invalidateLocalEventTypeCache(String accountName, String eventType) {
        AccountNameEventTypeKey key = this.tlsAccountNameEventTypeKey.get();
        key.reuse(accountName, eventType);
        this.createdOrUpdatedEventTypes.remove(key);
        log.debug("Removed event type [{}] associated to account [{}] from the local cache", (Object)eventType, (Object)accountName);
    }
}

