/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.google.common.base.Preconditions;
import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WindowsNativeLibrary {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsNativeLibrary.class);
    static final WindowsNativeLibrary INSTANCE = new WindowsNativeLibrary();
    private final List<ConsoleCtrlHandlerCallback> callbacks;

    private WindowsNativeLibrary() {
        try {
            Native.register((String)"kernel32");
            log.debug("[kernel32] library loaded");
        }
        catch (Throwable t) {
            log.error("Unable to link [kernel32] library. Native handlers will be disabled", t);
        }
        this.callbacks = new CopyOnWriteArrayList<ConsoleCtrlHandlerCallback>();
    }

    void add(ConsoleCtrlHandler handler) {
        Preconditions.checkNotNull((Object)handler);
        ConsoleCtrlHandlerCallback callback = new ConsoleCtrlHandlerCallback(handler);
        if (this.SetConsoleCtrlHandler(callback, true)) {
            this.callbacks.add(callback);
            return;
        }
        throw new RuntimeException("Unable to register handler. Native console ctrl handler registration failed");
    }

    native boolean SetConsoleCtrlHandler(StdCallLibrary.StdCallCallback var1, boolean var2);

    static final class ConsoleCtrlHandlerCallback
    implements StdCallLibrary.StdCallCallback {
        private final ConsoleCtrlHandler handler;

        ConsoleCtrlHandlerCallback(ConsoleCtrlHandler handler) {
            this.handler = handler;
        }

        public boolean callback(long dwCtrlType) {
            log.debug("Console control handler received event [{}]", (Object)dwCtrlType);
            return this.handler.handle((int)dwCtrlType);
        }
    }

    static interface ConsoleCtrlHandler {
        public static final long CTRL_CLOSE_EVENT = 2L;
        public static final long CTRL_C_EVENT = 0L;

        public boolean handle(long var1);
    }
}

