/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.command.CommandHelper;
import com.google.common.hash.Hashing;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.lang3.text.WordUtils;

public abstract class WindowsCommandHelper {
    private WindowsCommandHelper() {
    }

    public static String generateServiceName(String processName) {
        Path homeDir = CommandHelper.getPathToHomeDir();
        String homeDirString = homeDir.toAbsolutePath().toString();
        int hash = Hashing.murmur3_32().hashString((CharSequence)homeDirString, StandardCharsets.UTF_8).asInt();
        hash = Math.abs(hash);
        String homeDirHashString = BigInteger.valueOf(hash).toString(32).toUpperCase();
        String serviceName = processName.replace('-', ' ');
        return WordUtils.capitalize((String)("AppDynamics " + serviceName + " " + homeDirHashString), (char[])new char[]{' '});
    }
}

