/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.DefaultProcessHandler;
import com.appdynamics.common.executor.command.SubProcessManager;
import com.appdynamics.common.executor.command.windows.AppStopServiceOptions;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStopServiceCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppStopServiceCommand.class);
    private static final AppStopServiceOptions STOP_SERVICE_OPTIONS = new AppStopServiceOptions();
    private static final String STATE_STOPPED = "STOPPED";
    private final List<String> commandLineArguments = new ArrayList<String>();

    @Override
    public Options getOptions() {
        return STOP_SERVICE_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        AppStopServiceOptions.ParsedArguments parsedArguments = STOP_SERVICE_OPTIONS.parse(arguments);
        try {
            String serviceName = parsedArguments.getServiceName();
            this.commandLineArguments.add("sc");
            this.commandLineArguments.add("stop");
            this.commandLineArguments.add(serviceName);
            SubProcessManager.execute(this.commandLineArguments);
            this.waitForServiceShutdown(serviceName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void waitForServiceShutdown(String serviceName) {
        long startTimeMillis;
        List<String> serivceQueryCommand = Arrays.asList("sc", "query", serviceName);
        AtomicBoolean shutdownSucceeded = new AtomicBoolean(false);
        ShutdownStatusChecker shutdownStatusChecker = new ShutdownStatusChecker(serviceName, shutdownSucceeded);
        for (long timeRemainingMillis = 60000L; timeRemainingMillis > 0L; timeRemainingMillis -= System.currentTimeMillis() - startTimeMillis) {
            startTimeMillis = System.currentTimeMillis();
            SubProcessManager.execute(serivceQueryCommand, shutdownStatusChecker);
            if (shutdownSucceeded.get()) break;
            ConcurrencyHelper.sleep((long)1000L);
        }
        Preconditions.checkState((boolean)shutdownSucceeded.get(), (Object)"The service did not shutdown within [60] seconds");
    }

    private static class ShutdownStatusChecker
    extends DefaultProcessHandler {
        private final String serviceName;
        private final AtomicBoolean shutdownSucceeded;

        private ShutdownStatusChecker(String serviceName, AtomicBoolean shutdownSucceeded) {
            this.serviceName = serviceName;
            this.shutdownSucceeded = shutdownSucceeded;
        }

        @Override
        public void onStdout(ByteBuffer buffer, boolean closed) {
            try {
                String output = StandardCharsets.UTF_8.decode(buffer).toString();
                String[] lines = output.split(System.lineSeparator());
                if (lines.length > 3) {
                    String statusLine = lines[3];
                    String[] words = statusLine.split(" ");
                    String state = words[words.length - 1];
                    log.info("Service [{}] is in [{}] state", (Object)this.serviceName, (Object)state);
                    if (state.equals(AppStopServiceCommand.STATE_STOPPED)) {
                        this.shutdownSucceeded.set(true);
                        log.info("Stopped [{}] successfully", (Object)this.serviceName);
                    }
                } else {
                    log.debug("Cannot find the state of the service as output is not in the expected format");
                }
            }
            catch (Exception e) {
                log.warn("Error occurred while checking the state of [" + this.serviceName + "]", (Throwable)e);
            }
        }
    }
}

