/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.command.AppShutdownTaskCommand;
import com.appdynamics.common.executor.command.AppStopCommand;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.executor.command.windows.WindowsNativeLibrary;
import java.nio.file.Path;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStartCommand
extends com.appdynamics.common.executor.command.AppStartCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppStartCommand.class);

    public AppStartCommand(String mainClassName) {
        super(mainClassName);
        try {
            WindowsNativeLibrary.INSTANCE.add(new WindowsNativeLibrary.ConsoleCtrlHandler(){

                @Override
                public boolean handle(long code) {
                    if (2L == code || 0L == code) {
                        log.debug("Running graceful exit on windows");
                        AppStartCommand.this.stopProcessAndWait();
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            log.warn("Ctrl-c handler may not work", (Throwable)e);
        }
    }

    private void stopProcessAndWait() {
        Path pathToProperties = this.getPathToProperties();
        try {
            if (pathToProperties != null) {
                Properties p = CommandHelper.readProperties(pathToProperties);
                String processName = CommandHelper.readProperty(p, "ad.process.name");
                Path homeDir = CommandHelper.getPathToHomeDir();
                this.forceStopIfRunning("elasticsearch", homeDir);
                this.forceStopIfRunning(processName, homeDir);
            }
        }
        catch (Throwable t) {
            log.error("Error occurred while stopping the process", t);
        }
    }

    @Override
    protected AppStopCommand getAppStopCommand() {
        return new AppShutdownTaskCommand();
    }
}

