/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.AppCommand;
import com.appdynamics.common.executor.command.AppStopCommand;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.executor.command.windows.AppRunServiceInternalOptions;
import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRunServiceInternalCommand
implements AppCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppRunServiceInternalCommand.class);
    private static final AppRunServiceInternalOptions RUN_SERVICE_OPTIONS = new AppRunServiceInternalOptions();
    private final List<String> commandLineArguments = new ArrayList<String>();

    @Override
    public boolean addYmlToArguments() {
        return true;
    }

    @Override
    public Options getOptions() {
        return RUN_SERVICE_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        AppRunServiceInternalOptions.ParsedArguments parsedArguments = RUN_SERVICE_OPTIONS.parse(arguments);
        try {
            Path pathToProperties = Paths.get(parsedArguments.getPathToProperties(), new String[0]);
            Path absolutePathToProperties = pathToProperties.toAbsolutePath();
            CommandHelper.checkFileExists(absolutePathToProperties);
            Properties analyticsServiceProperties = CommandHelper.readProperties(absolutePathToProperties);
            String processName = CommandHelper.readProperty(analyticsServiceProperties, "ad.process.name");
            Path pathToYml = null;
            if (this.addYmlToArguments()) {
                pathToYml = CommandHelper.getPathToConfDir().resolve(processName + ".yml");
                CommandHelper.checkFileExists(pathToYml);
            }
            CommandHelper.addCommandLineArguments(absolutePathToProperties, (Optional<Path>)Optional.fromNullable(pathToYml), this.commandLineArguments);
            this.forceStopIfRunning(processName);
            String mainClassName = parsedArguments.getClassname();
            Class<?> mainClass = Class.forName(mainClassName);
            String[] commandLineArgs = new String[this.commandLineArguments.size()];
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{this.commandLineArguments.toArray(commandLineArgs)});
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void forceStopIfRunning(String processName) {
        AppStopCommand stopCommand = this.getAppStopCommand();
        Path homeDir = CommandHelper.getPathToHomeDir();
        Path pidFile = homeDir.resolve(processName + ".id");
        if (Files.exists(pidFile, new LinkOption[0]) && !Files.isDirectory(pidFile, new LinkOption[0])) {
            Arguments stopArguments = new Arguments("stop", "-f", pidFile.toString());
            stopCommand.execute(stopArguments);
        }
    }

    protected AppStopCommand getAppStopCommand() {
        return new AppStopCommand();
    }
}

