/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command.windows;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.executor.command.SubProcessManager;
import com.appdynamics.common.executor.command.windows.AppListServiceOptions;
import com.appdynamics.common.executor.command.windows.WindowsCommandHelper;
import com.zaxxer.nuprocess.NuAbstractProcessHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppListServiceCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppListServiceCommand.class);
    private static final AppListServiceOptions LIST_SERVICE_OPTIONS = new AppListServiceOptions();

    @Override
    public Options getOptions() {
        return LIST_SERVICE_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        try {
            for (Path pathToPropertiesFiles : CommandHelper.getPropertiesFilesInConfDir()) {
                Properties p = CommandHelper.readProperties(pathToPropertiesFiles);
                String processName = CommandHelper.readProperty(p, "ad.process.name");
                String serviceName = WindowsCommandHelper.generateServiceName(processName);
                ArrayList<String> commandLineArguments = new ArrayList<String>();
                commandLineArguments.add("sc");
                commandLineArguments.add("qc");
                commandLineArguments.add(serviceName);
                this.executeCommand(commandLineArguments);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void executeCommand(List<String> commandLineArguments) {
        SubProcessManager.execute(commandLineArguments, new ListServiceProcessHandler());
    }

    private static class ListServiceProcessHandler
    extends NuAbstractProcessHandler {
        String output = "";

        private ListServiceProcessHandler() {
        }

        public void onStderr(ByteBuffer buffer, boolean closed) {
            if (buffer == null || closed) {
                return;
            }
            log.info(StandardCharsets.UTF_8.decode(buffer).toString());
        }

        public void onStdout(ByteBuffer buffer, boolean closed) {
            if (buffer == null || closed) {
                return;
            }
            this.output = this.output + StandardCharsets.UTF_8.decode(buffer).toString();
        }

        public void onExit(int exitStatus) {
            if (exitStatus == 0) {
                log.info(this.output);
            }
        }
    }
}

