/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.util.Args4jHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.kohsuke.args4j.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelpCommand.class);
    static final HelpOptions HELP_OPTIONS = new HelpOptions();
    final List<Command> commands;

    public HelpCommand(List<Command> commands) {
        this.commands = HelpCommand.readVisibleCommands(commands);
    }

    @Override
    public Options getOptions() {
        return HELP_OPTIONS;
    }

    @Override
    public final void execute(Arguments arguments) {
        Pair<String, Optional<Command>> pair = this.listAllAndSuggest(arguments);
        log.info((String)pair.getLeft());
    }

    private static List<Command> readVisibleCommands(List<Command> commands) {
        ArrayList<Command> visibleCommands = new ArrayList<Command>();
        for (Command command : commands) {
            if (command.getOptions().isHidden()) continue;
            visibleCommands.add(command);
        }
        return visibleCommands;
    }

    public final Pair<String, Optional<Command>> listAllAndSuggest(Arguments arguments) {
        StringBuilder sb = new StringBuilder();
        Command suggestedCommand = null;
        sb.append("\n").append("You provided [");
        Joiner.on((char)' ').appendTo(sb, (Object[])arguments.getItems());
        sb.append("]\n\nYour options are:\n\n");
        LinkedList<ImmutablePair> commandsByMatchDistance = new LinkedList<ImmutablePair>();
        String givenFirstWord = StringUtils.trimToEmpty((String)arguments.extractFirstWordIfPresent());
        for (Command command : this.commands) {
            String commandName = command.getOptions().getName();
            int matchDistance = StringUtils.getFuzzyDistance((CharSequence)givenFirstWord, (CharSequence)commandName, (Locale)Locale.ENGLISH);
            commandsByMatchDistance.add(new ImmutablePair((Object)matchDistance, (Object)command));
            sb.append(command.getOptions().getUsage()).append("\n");
        }
        Collections.sort(commandsByMatchDistance, new Comparator<Pair<Integer, Command>>(){

            @Override
            public int compare(Pair<Integer, Command> o1, Pair<Integer, Command> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        if (commandsByMatchDistance.size() > 0) {
            String suggestedCommandName;
            log.debug("Suggestions {}", commandsByMatchDistance);
            Pair closestMatchingPair = (Pair)commandsByMatchDistance.getLast();
            if ((Integer)closestMatchingPair.getLeft() > 0 && !(suggestedCommandName = (suggestedCommand = (Command)closestMatchingPair.getRight()).getOptions().getName()).equals(givenFirstWord)) {
                sb.append("\nDid you mean [").append(suggestedCommandName).append("]?");
            }
        }
        return new ImmutablePair((Object)sb.toString(), (Object)Optional.fromNullable(suggestedCommand));
    }

    static class HelpOptions
    implements Options {
        static final String OPTION_NAME = "help";

        HelpOptions() {
        }

        @Override
        public String getName() {
            return OPTION_NAME;
        }

        @Override
        public String getUsage() {
            return "help " + Args4jHelper.extractUsage(new ParsedArguments());
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean canExecute(Arguments arguments) {
            String[] items = arguments.getItems();
            return items != null && items.length > 0 && items[0].equals(OPTION_NAME);
        }
    }

    public static class ParsedArguments {
        @Argument(required=false, usage="Print options", metaVar=" ")
        private List<String> ignored;

        @Generated
        public ParsedArguments() {
        }

        @Generated
        public List<String> getIgnored() {
            return this.ignored;
        }

        @Generated
        public void setIgnored(List<String> ignored) {
            this.ignored = ignored;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedArguments)) {
                return false;
            }
            ParsedArguments other = (ParsedArguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$ignored = this.getIgnored();
            List<String> other$ignored = other.getIgnored();
            return !(this$ignored == null ? other$ignored != null : !((Object)this$ignored).equals(other$ignored));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParsedArguments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $ignored = this.getIgnored();
            result = result * 59 + ($ignored == null ? 43 : ((Object)$ignored).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HelpCommand.ParsedArguments(ignored=" + String.valueOf(this.getIgnored()) + ")";
        }
    }
}

