/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.AppStopOptions;
import com.appdynamics.common.executor.command.CommandHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.ProcessUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;

public class AppStopCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppStopCommand.class);
    private static final AppStopOptions STOP_OPTIONS = new AppStopOptions();

    @Override
    public Options getOptions() {
        return STOP_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        AppStopOptions.ParsedArguments parsedArguments = STOP_OPTIONS.parse(arguments);
        List<String> inputArguments = parsedArguments.getArguments();
        int gracefulStopWaitSecs = parsedArguments.getGracefulStopWaitSecs();
        gracefulStopWaitSecs = gracefulStopWaitSecs > 0 ? gracefulStopWaitSecs : 1;
        boolean isForceStop = parsedArguments.isForceStop();
        Path[] pidFilePaths = null;
        Path pathToApplicationHome = this.getPathToApplicationHome();
        if (inputArguments != null && inputArguments.size() > 0) {
            pidFilePaths = new Path[inputArguments.size()];
            int k = 0;
            for (String argument : inputArguments) {
                pidFilePaths[k++] = pathToApplicationHome.resolve(argument);
            }
        } else {
            pidFilePaths = AppStopCommand.getPidFiles(pathToApplicationHome);
        }
        this.stopAllProcesses(gracefulStopWaitSecs, isForceStop, pidFilePaths);
    }

    final void stopAllProcesses(int waitSecs, boolean forceStop, Path ... pidFilePaths) {
        Throwable collectedExceptions = null;
        for (Path pathToPidFile : pidFilePaths) {
            try {
                this.stopProcess(pathToPidFile, waitSecs, forceStop);
            }
            catch (Exception nested) {
                if (collectedExceptions == null) {
                    collectedExceptions = new RuntimeException("Error(s) occurred while stopping processes");
                }
                collectedExceptions.addSuppressed(nested);
                if (!Iterators.any(Throwables.getCausalChain((Throwable)nested).iterator(), (Predicate)Predicates.instanceOf(InterruptedException.class))) continue;
                log.info("Thread has been interrupted. Aborting further actions");
                break;
            }
        }
        if (collectedExceptions != null) {
            throw collectedExceptions;
        }
    }

    /*
     * Exception decompiling
     */
    final void stopProcess(Path pathToPidFile, int waitSecs, boolean forceStop) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void stopProcess(Path pathToPidFile, int waitSecs, boolean forceStop, int pid) throws InterruptedException, IOException, TimeoutException {
        this.defaultStopProcess(waitSecs, forceStop, pid);
    }

    @VisibleForTesting
    void defaultStopProcess(int waitSecs, boolean forceStop, int pid) throws InterruptedException, TimeoutException, IOException {
        PidProcess process = Processes.newPidProcess((int)pid);
        if (forceStop) {
            ProcessUtil.destroyGracefullyOrForcefullyAndWait((SystemProcess)process, (long)waitSecs, (TimeUnit)TimeUnit.SECONDS, (long)waitSecs, (TimeUnit)TimeUnit.SECONDS);
        } else {
            ProcessUtil.destroyGracefullyAndWait((SystemProcess)process, (long)waitSecs, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    Path getPathToApplicationHome() {
        return CommandHelper.getPathToHomeDir();
    }

    private static Path[] getPidFiles(Path pathToApplicationHome) {
        File applicationHomeDirectory = pathToApplicationHome.toFile();
        File[] pidFiles = applicationHomeDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".id");
            }
        });
        if (pidFiles == null) {
            return new Path[0];
        }
        Path[] pathToPidFiles = new Path[pidFiles.length];
        int k = 0;
        for (File pidFile : pidFiles) {
            pathToPidFiles[k++] = pidFile.toPath();
        }
        return pathToPidFiles;
    }

    @Generated
    public String toString() {
        return "AppStopCommand()";
    }
}

