/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.AppCommand;
import com.appdynamics.common.executor.command.AppConstants;
import com.appdynamics.common.executor.command.AppStartOptions;
import com.appdynamics.common.executor.command.AppStopCommand;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.executor.command.SubProcessManager;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStartCommand
implements AppCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppStartCommand.class);
    public static final AppStartOptions START_OPTIONS = new AppStartOptions();
    private final List<String> commandLineArguments = new ArrayList<String>();
    private final String mainClassName;
    private Path pathToProperties;

    public AppStartCommand(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public boolean addYmlToArguments() {
        return true;
    }

    @Override
    public Options getOptions() {
        return START_OPTIONS;
    }

    @Override
    public void execute(Arguments arguments) {
        AppStartOptions.ParsedArguments parsedArguments = START_OPTIONS.parse(arguments);
        try {
            Properties systemProperties;
            this.pathToProperties = Paths.get(parsedArguments.getPathToProperties(), new String[0]);
            Path absolutePathToProperties = this.pathToProperties.toAbsolutePath();
            CommandHelper.checkFileExists(absolutePathToProperties);
            Properties appProperties = CommandHelper.readProperties(absolutePathToProperties);
            String processName = CommandHelper.readProperty(appProperties, "ad.process.name");
            Path pathToConfDir = CommandHelper.getPathToConfDir();
            Path pathToHomeDir = CommandHelper.getPathToHomeDir();
            Path pathToVmOptions = CommandHelper.getPathToVmOptions(appProperties, pathToConfDir);
            Path pathToYml = null;
            if (this.addYmlToArguments()) {
                pathToYml = pathToConfDir.resolve(processName + ".yml");
                CommandHelper.checkFileExists(pathToYml);
            }
            CommandHelper.checkFileExists(pathToVmOptions);
            if (parsedArguments.isForceStart()) {
                this.forceStopIfRunning(processName, pathToHomeDir);
            }
            String classPath = CommandHelper.escapePath(AppStartCommand.readClassPath(pathToHomeDir));
            if (StringUtils.isEmpty((CharSequence)parsedArguments.getDryRun())) {
                this.commandLineArguments.add(CommandHelper.getJavaExecutablePath());
            }
            if ((systemProperties = parsedArguments.toProperties()).size() > 0) {
                AppStartCommand.checkForDryRunSeparator(parsedArguments.getSystemProperties(), parsedArguments.getDryRun());
                appProperties.putAll((Map<?, ?>)systemProperties);
                this.addSystemProperties(systemProperties);
            }
            CommandHelper.addVmOptions(appProperties, pathToVmOptions, pathToHomeDir, this.commandLineArguments);
            this.commandLineArguments.add("-classpath");
            this.commandLineArguments.add(classPath);
            this.commandLineArguments.add(this.mainClassName);
            CommandHelper.addCommandLineArguments(absolutePathToProperties, (Optional<Path>)Optional.fromNullable((Object)pathToYml), this.commandLineArguments);
            if (StringUtils.isEmpty((CharSequence)parsedArguments.getDryRun())) {
                this.executeCommand(this.commandLineArguments);
            } else {
                String finalCommandLine = Joiner.on((String)parsedArguments.getDryRun()).join(this.commandLineArguments);
                log.info("Program arguments:\n\n" + parsedArguments.getDryRun() + "{}", (Object)finalCommandLine);
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String readClassPath(Path pathToHomeDirectory) {
        String classPath = pathToHomeDirectory.toString() + AppConstants.LIB_PATH_ALL;
        log.debug("Class path lib directory [{}]", (Object)classPath);
        return classPath;
    }

    private void addSystemProperties(Properties systemProperties) {
        for (Map.Entry<Object, Object> property : systemProperties.entrySet()) {
            String escapedValue = CommandHelper.escapeValue((String)property.getValue());
            this.commandLineArguments.add("-D" + String.valueOf(property.getKey()) + "=" + escapedValue);
        }
    }

    void executeCommand(List<String> commandLineArguments) {
        SubProcessManager.execute(commandLineArguments);
    }

    protected void forceStopIfRunning(String processName, Path homeDir) {
        AppStopCommand stopCommand = this.getAppStopCommand();
        Path pidFile = homeDir.resolve(processName + ".id");
        if (Files.exists(pidFile, new LinkOption[0]) && !Files.isDirectory(pidFile, new LinkOption[0])) {
            Arguments stopArguments = new Arguments("stop", "-f", pidFile.toString());
            stopCommand.execute(stopArguments);
        }
    }

    protected AppStopCommand getAppStopCommand() {
        return new AppStopCommand();
    }

    private static void checkForDryRunSeparator(List<String> properties, String dryRun) {
        for (String property : properties) {
            if (!property.contains(dryRun)) continue;
            throw new IllegalArgumentException("Property [" + property + "] should not contain dry run separator [" + dryRun + "]");
        }
    }

    @Generated
    public String toString() {
        return "AppStartCommand(commandLineArguments=" + String.valueOf(this.getCommandLineArguments()) + ", mainClassName=" + this.getMainClassName() + ", pathToProperties=" + String.valueOf(this.getPathToProperties()) + ")";
    }

    @Generated
    public List<String> getCommandLineArguments() {
        return this.commandLineArguments;
    }

    @Generated
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Generated
    public Path getPathToProperties() {
        return this.pathToProperties;
    }
}

