/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.executor.command;

import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.Command;
import com.appdynamics.common.executor.Options;
import com.appdynamics.common.executor.command.AppHealthCheckOptions;
import com.appdynamics.common.executor.command.CommandHelper;
import com.appdynamics.common.io.IoHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppHealthCheckCommand
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppHealthCheckCommand.class);
    public static final String STATUS_NOT_AVAILABLE = "Not available";
    public static final String STATUS_NOT_HEALTHY = "Not healthy";
    public static final String STATUS_HEALTHY = "Healthy";
    private static final String HEALTH_CHECK_URL_SUFFIX = "/healthcheck?pretty=true";
    private static final AppHealthCheckOptions HEALTH_CHECK_OPTIONS = new AppHealthCheckOptions();

    @Override
    public Options getOptions() {
        return HEALTH_CHECK_OPTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(Arguments arguments) {
        parsedArguments = AppHealthCheckCommand.HEALTH_CHECK_OPTIONS.parse(arguments);
        try {
            hostAndPorts = new LinkedList<HostAndPort>();
            for (String strPathToProperties : parsedArguments.getPathsToProperties()) {
                pathToProperties = Paths.get(strPathToProperties, new String[0]);
                absolutePathToProperties = pathToProperties.toAbsolutePath();
                CommandHelper.checkFileExists(absolutePathToProperties);
                appProperties = CommandHelper.readProperties(absolutePathToProperties);
                dwHost = CommandHelper.readProperty(appProperties, "ad.dw.http.host");
                dwAdminPortString = CommandHelper.readProperty(appProperties, "ad.dw.http.adminPort");
                dwAdminPort = Integer.parseInt(dwAdminPortString);
                hostAndPort = HostAndPort.fromParts((String)dwHost, (int)dwAdminPort);
                hostAndPorts.add(hostAndPort);
            }
            for (String hostAndPortString : parsedArguments.getHostsAndPorts()) {
                multipleHostAndPorts = IoHelper.parseHostAndPortCsv((String)hostAndPortString);
                hostAndPorts.addAll(multipleHostAndPorts);
            }
            if (hostAndPorts.isEmpty()) {
                AppHealthCheckCommand.log.info("No host and port information was provided");
                return;
            }
            statuses = new ArrayList<String>(hostAndPorts.size());
            messages = new ArrayList<String>(hostAndPorts.size());
            allOk = true;
            try {
                requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
                httpClient = HttpClientBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoReuseAddress(true).build()).setDefaultRequestConfig(requestConfig).disableAutomaticRetries().build();
                try lbl-1000:
                // 6 sources

                {
                    block19: for (HostAndPort hostAndPort : hostAndPorts) {
                        url = AppHealthCheckCommand.makeHttpUrl(hostAndPort);
                        httpGet = new HttpGet(url);
                        try {
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                entity = response.getEntity();
                                entityString = EntityUtils.toString((HttpEntity)entity, (Charset)Charsets.UTF_8);
                                statusLine = response.getStatusLine();
                                status = statusLine.getStatusCode() + " " + statusLine.getReasonPhrase();
                                statuses.add(status);
                                messages.add(entityString);
                                switch (statusLine.getStatusCode()) {
                                    case 200: 
                                    case 202: {
                                        ** break;
                                    }
                                    default: {
                                        allOk = false;
                                        continue block19;
                                    }
                                }
                            }
                            finally {
                                if (response == null) continue;
                                response.close();
                            }
                        }
                        catch (Throwable t) {
                            allOk = false;
                            statuses.add("Not available");
                            messages.add(Throwables.getStackTraceAsString((Throwable)t));
                        }
                    }
                }
                finally {
                    Closeables.close((Closeable)httpClient, (boolean)true);
                }
            }
            catch (Throwable t) {
                allOk = false;
                AppHealthCheckCommand.log.error("Error occurred while checking health", t);
            }
            AppHealthCheckCommand.reportAndEnd(allOk, parsedArguments.isVerbose(), hostAndPorts, statuses, messages);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String makeHttpUrl(HostAndPort hostAndPort) {
        Preconditions.checkArgument((boolean)hostAndPort.hasPort(), (String)"Port information was not provided for [%s]", (Object)hostAndPort.getHost());
        return "http://" + hostAndPort.getHost() + ":" + hostAndPort.getPort() + HEALTH_CHECK_URL_SUFFIX;
    }

    private static void reportAndEnd(boolean allOk, boolean verbose, List<HostAndPort> hostAndPorts, List<String> statuses, List<String> messages) {
        log.info("Individual statuses below:");
        int i = 0;
        for (HostAndPort hostAndPort : hostAndPorts) {
            String status = statuses.get(i);
            if (verbose) {
                String message = messages.get(i);
                log.info("[{}] status is [\n{}\n{}]", new Object[]{hostAndPort, status, message});
            } else {
                log.info("[{}] status is [{}]", (Object)hostAndPort, (Object)status);
            }
            ++i;
        }
        if (!allOk) {
            log.warn("Overall status: Not healthy");
        } else {
            log.info("Overall status Healthy");
        }
    }
}

