/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.utils.overrides;

import com.appdynamics.voltron.utils.StringUtil;
import com.appdynamics.voltron.utils.annotations.FollowObject;
import com.appdynamics.voltron.utils.overrides.FieldOverrider;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.util.Collection;

public class DefaultOverrider
implements Overrider {
    private Collection<FieldOverrider> fieldOverriders;

    @Inject
    public DefaultOverrider(Collection<FieldOverrider> fieldOverriders) {
        this.fieldOverriders = fieldOverriders;
    }

    @Override
    public void override(Object target) {
        Field[] fields;
        for (Field field : fields = target.getClass().getDeclaredFields()) {
            Object newValue;
            Object originalValue;
            field.setAccessible(true);
            try {
                originalValue = field.get(target);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot get field " + String.valueOf(field) + " for overriding.", e);
            }
            this.followObjectIfNeeded(field, originalValue);
            String newValueStr = null;
            for (FieldOverrider fieldOverrider : this.fieldOverriders) {
                newValueStr = fieldOverrider.getDataFor(field, originalValue, newValueStr, target);
            }
            if (StringUtil.isBlank(newValueStr) || (newValue = DefaultOverrider.deserialize(field.getType(), newValueStr)) == null) continue;
            try {
                field.set(target, newValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not set field " + String.valueOf(field) + " for overriding.", e);
            }
        }
    }

    private void followObjectIfNeeded(Field field, Object originalValue) {
        FollowObject annotation = field.getAnnotation(FollowObject.class);
        if (annotation != null) {
            if (originalValue == null) {
                throw new IllegalArgumentException("Could not follow the field " + field.getName() + ". The value for a field annotated with @" + FollowObject.class.getSimpleName() + " cannot be null.");
            }
            if (originalValue instanceof Collection) {
                this.followCollection(originalValue);
            } else {
                this.override(originalValue);
            }
        }
    }

    private void followCollection(Object originalValue) {
        for (Object item : (Collection)originalValue) {
            this.override(item);
        }
    }

    static Object deserialize(Class<?> klass, String newValueStr) {
        if (klass.equals(String.class)) {
            return newValueStr;
        }
        if (klass.equals(Long.TYPE) || klass.equals(Long.class)) {
            return Long.valueOf(newValueStr);
        }
        if (klass.equals(Integer.TYPE) || klass.equals(Integer.class)) {
            return Integer.valueOf(newValueStr);
        }
        if (klass.equals(Short.TYPE) || klass.equals(Short.class)) {
            return Short.valueOf(newValueStr);
        }
        if (klass.equals(Byte.TYPE) || klass.equals(Byte.class)) {
            return Byte.valueOf(newValueStr);
        }
        if (klass.equals(Boolean.TYPE) || klass.equals(Boolean.class)) {
            return Boolean.valueOf(newValueStr);
        }
        if (klass.equals(Float.TYPE) || klass.equals(Float.class)) {
            return Float.valueOf(newValueStr);
        }
        if (klass.equals(Double.TYPE) || klass.equals(Double.class)) {
            return Double.valueOf(newValueStr);
        }
        throw new IllegalArgumentException("Cannot deserialize overrides for fields of type " + String.valueOf(klass));
    }
}

