/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.util.var.AbstractVariableResolver;
import com.appdynamics.common.util.var.CalendarVariableResolver;
import com.appdynamics.common.util.var.ChainedVariableResolver;
import com.appdynamics.common.util.var.SystemPropertyResolver;
import com.appdynamics.common.util.var.SystemVariableResolver;
import com.appdynamics.common.util.var.VariableResolver;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public final class LocalContextVariableResolver
extends AbstractVariableResolver {
    private static final VariableResolver DEFAULT_RESOLVER = new ChainedVariableResolver(SystemPropertyResolver.INSTANCE, SystemVariableResolver.INSTANCE, CalendarVariableResolver.INSTANCE);
    private static final ThreadLocal<LocalContextVariableResolver> PER_THREAD_INSTANCE = new ThreadLocal<LocalContextVariableResolver>(){

        @Override
        protected LocalContextVariableResolver initialValue() {
            return new LocalContextVariableResolver();
        }
    };
    private Map<String, String> localContextMap;

    @Override
    public Object resolve(String variable) {
        String obj = this.localContextMap.get(variable);
        if (obj != null) {
            return obj;
        }
        return DEFAULT_RESOLVER.resolve(variable);
    }

    @Override
    public Object resolve(String variable, String variableExtension) {
        return DEFAULT_RESOLVER.resolve(variable, variableExtension);
    }

    private VariableResolver setContext(Map<String, String> localContextMap) {
        this.localContextMap = (Map)MoreObjects.firstNonNull(localContextMap, Collections.emptyMap());
        return this;
    }

    public static VariableResolver getResolver(Map<String, String> localContextMap) {
        return PER_THREAD_INSTANCE.get().setContext(localContextMap);
    }

    @Generated
    private LocalContextVariableResolver() {
    }
}

