/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.type;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueType {
    TIMESTAMP{

        @Override
        public ValueType and(ValueType combinedWith) {
            switch (combinedWith) {
                case TIMESTAMP: {
                    return this;
                }
            }
            return STRING;
        }

        @Override
        public Object cast(String value) {
            log.warn("Attempt to parse as a timestamp failed. Provide pattern for parsing.");
            return value;
        }

        @Override
        public Object cast(String value, String format) {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date date = null;
            try {
                date = formatter.parse(value);
            }
            catch (ParseException e) {
                log.error(String.format("Attempt to parse value [%s] as a date failed with %s.", value, e));
                e.printStackTrace();
            }
            if (date != null) {
                return date.getTime();
            }
            return value;
        }
    }
    ,
    NUMBER{

        @Override
        public ValueType and(ValueType combinedWith) {
            switch (combinedWith) {
                case NUMBER: {
                    return this;
                }
            }
            return STRING;
        }

        @Override
        public Object cast(String value) {
            Double d = Doubles.tryParse((String)value);
            if (d != null) {
                return d;
            }
            return null;
        }

        @Override
        public Object cast(String value, String format) {
            return this.cast(value);
        }
    }
    ,
    BOOLEAN{

        @Override
        public ValueType and(ValueType combinedWith) {
            return STRING.and(combinedWith);
        }

        @Override
        public Object cast(String value) {
            Boolean b = BooleanUtils.toBooleanObject((String)value);
            if (b != null) {
                return b;
            }
            return null;
        }

        @Override
        public Object cast(String value, String format) {
            return this.cast(value);
        }
    }
    ,
    STRING{

        @Override
        public ValueType and(ValueType combinedWith) {
            switch (combinedWith) {
                default: 
            }
            return STRING;
        }

        @Override
        public Object cast(String value) {
            return value;
        }

        @Override
        public Object cast(String value, String format) {
            return this.cast(value);
        }
    }
    ,
    UNKNOWN{

        @Override
        public ValueType and(ValueType combinedWith) {
            switch (combinedWith) {
                case UNKNOWN: {
                    return UNKNOWN;
                }
            }
            return STRING;
        }

        @Override
        public Object cast(String value) {
            return value;
        }

        @Override
        public Object cast(String value, String format) {
            return this.cast(value);
        }
    };

    @Generated
    private static final Logger log;
    public static final ImmutableList<ValueType> VALID_VALUES;

    public abstract ValueType and(ValueType var1);

    public abstract Object cast(String var1);

    public abstract Object cast(String var1, String var2);

    public static ValueType defaultIfNull(ValueType vt) {
        return vt == null ? UNKNOWN : vt;
    }

    static {
        log = LoggerFactory.getLogger(ValueType.class);
        VALID_VALUES = ImmutableList.of((Object)((Object)UNKNOWN), (Object)((Object)BOOLEAN), (Object)((Object)NUMBER), (Object)((Object)STRING), (Object)((Object)TIMESTAMP));
    }
}

