/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.reflection;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import lombok.Generated;

public final class AnnotationHelper {
    public static <T extends Annotation> Optional<T> searchForAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        T methodAnnotation = method.getAnnotation(annotationClass);
        if (methodAnnotation != null) {
            return Optional.of(methodAnnotation);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> interfaceClass : interfaces = method.getDeclaringClass().getInterfaces()) {
            try {
                Method superMethod = interfaceClass.getMethod(method.getName(), method.getParameterTypes());
                T superMethodAnnotation = superMethod.getAnnotation(annotationClass);
                if (superMethodAnnotation == null) continue;
                return Optional.of(superMethodAnnotation);
            }
            catch (NoSuchMethodException superMethod) {
                // empty catch block
            }
        }
        T classAnnotation = declaringClass.getAnnotation(annotationClass);
        if (classAnnotation != null) {
            return Optional.of(classAnnotation);
        }
        for (Class<?> interfaceClass : interfaces) {
            T interfaceAnnotation = interfaceClass.getAnnotation(annotationClass);
            if (interfaceAnnotation == null) continue;
            return Optional.of(interfaceAnnotation);
        }
        return Optional.absent();
    }

    @Generated
    private AnnotationHelper() {
    }
}

