/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.misc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class Collections {
    private Collections() {
    }

    public static <T> List<T> castOrNewList(@Nullable Object existingSingletonOrList) {
        List<Object> newList = null;
        if (existingSingletonOrList == null) {
            newList = new ArrayList(4);
        } else if (existingSingletonOrList instanceof List) {
            newList = (List)existingSingletonOrList;
        } else {
            newList = new ArrayList(4);
            newList.add(existingSingletonOrList);
        }
        return newList;
    }

    public static <K, V> boolean putIfAbsentOrEnsureEquals(Map<K, V> map, K key, V newValue) {
        V oldValue = map.get(key);
        if (oldValue == null) {
            Preconditions.checkState((map.put(key, newValue) == null ? 1 : 0) != 0);
            return true;
        }
        Preconditions.checkState((boolean)oldValue.equals(newValue), (String)"There was already another value [%s] associated with the key [%s]. So, the new value [%s] could not be set", oldValue, key, newValue);
        return false;
    }
}

