/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.locks;

import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.locks.ClusterLock;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLockConditionalRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterLockConditionalRunnable.class);
    @NonNull
    private final String lockId;
    @NonNull
    private final Runnable delegate;
    @NonNull
    private final ClusterLock clusterLock;
    @NonNull
    private final TimeUnitConfiguration lockAcquisitionTimeout;

    @Override
    public final void run() {
        try {
            this.clusterLock.acquireAndExecute(this.lockId, this.lockAcquisitionTimeout, () -> {
                this.delegate.run();
                return null;
            });
        }
        catch (TimeoutException e) {
            log.debug("Timed out waiting for lock: lockId=[{}]", (Object)this.lockId, (Object)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @ConstructorProperties(value={"lockId", "delegate", "clusterLock", "lockAcquisitionTimeout"})
    @Generated
    public ClusterLockConditionalRunnable(@NonNull String lockId, @NonNull Runnable delegate, @NonNull ClusterLock clusterLock, @NonNull TimeUnitConfiguration lockAcquisitionTimeout) {
        if (lockId == null) {
            throw new IllegalArgumentException("lockId is marked non-null but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked non-null but is null");
        }
        if (clusterLock == null) {
            throw new IllegalArgumentException("clusterLock is marked non-null but is null");
        }
        if (lockAcquisitionTimeout == null) {
            throw new IllegalArgumentException("lockAcquisitionTimeout is marked non-null but is null");
        }
        this.lockId = lockId;
        this.delegate = delegate;
        this.clusterLock = clusterLock;
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }
}

