/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.lifecycle;

import com.appdynamics.common.util.concurrent.ManualResetEvent;
import com.appdynamics.common.util.lifecycle.RunningState;

public class MutableRunningState
implements RunningState {
    private final ManualResetEvent runningEvent;

    public MutableRunningState(boolean initial) {
        this.runningEvent = new ManualResetEvent(!initial);
    }

    @Override
    public void set(boolean running) {
        if (running) {
            this.runningEvent.clear();
        } else {
            this.runningEvent.signal();
        }
    }

    @Override
    public boolean get() {
        return !this.runningEvent.get();
    }

    public void sleepWhileRunning(long milliseconds) throws InterruptedException {
        this.runningEvent.waitForSingleEvent(milliseconds);
    }
}

