/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.json;

import com.appdynamics.common.util.misc.TriConsumer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class JsonTreeWalker {
    public static final int PATH_DEPTH_LIMIT = 1000;

    public static void walkTree(JsonNode root, Consumer<JsonNode> nodeConsumer) {
        JsonTreeWalker.walkTree(root, nodeConsumer, 0);
    }

    private static void walkTree(JsonNode currentNode, Consumer<JsonNode> nodeConsumer, int currentDepth) {
        if (currentDepth >= 1000) {
            throw new IllegalArgumentException("While walking the Json tree, exceeded path depth limit of [1000]");
        }
        if (currentNode == null) {
            return;
        }
        nodeConsumer.accept(currentNode);
        if (currentNode.size() > 0) {
            Iterator elements = currentNode.elements();
            while (elements.hasNext()) {
                JsonNode node = (JsonNode)elements.next();
                JsonTreeWalker.walkTree(node, nodeConsumer, currentDepth + 1);
            }
        }
    }

    public static void walkTreeWithParent(JsonNode root, TriConsumer<JsonNode, ArrayNode, Integer> arrayNodeConsumer, TriConsumer<JsonNode, ObjectNode, String> objectNodeConsumer) {
        JsonTreeWalker.walkTreeWithParent(root, arrayNodeConsumer, objectNodeConsumer, 0);
    }

    private static void walkTreeWithParent(JsonNode currentNode, TriConsumer<JsonNode, ArrayNode, Integer> arrayNodeConsumer, TriConsumer<JsonNode, ObjectNode, String> objectNodeConsumer, Integer currentDepth) {
        if (currentDepth >= 1000) {
            throw new IllegalArgumentException("While walking the Json tree, exceeded path depth limit of [1000]");
        }
        if (currentNode == null) {
            return;
        }
        if (currentNode.isArray()) {
            int index = 0;
            Iterator elements = currentNode.elements();
            while (elements.hasNext()) {
                JsonNode node = (JsonNode)elements.next();
                arrayNodeConsumer.accept(node, (ArrayNode)currentNode, index);
                ++index;
                JsonTreeWalker.walkTreeWithParent(node, arrayNodeConsumer, objectNodeConsumer, currentDepth + 1);
            }
        }
        if (currentNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)currentNode;
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode node = (JsonNode)field.getValue();
                objectNodeConsumer.accept(node, objectNode, (String)field.getKey());
                JsonTreeWalker.walkTreeWithParent(node, arrayNodeConsumer, objectNodeConsumer, currentDepth + 1);
            }
        }
    }
}

