/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import lombok.Generated;

public final class JacksonUtils {
    public static JsonNode uncheckedReadTree(ObjectMapper mapper, String serialized) {
        try {
            return mapper.readTree(serialized);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T uncheckedReadValue(ObjectMapper mapper, byte[] bytes, Class<T> clazz) {
        try {
            return (T)mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> byte[] uncheckedWriteValueAsBytes(ObjectMapper mapper, T object) {
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String uncheckedWriteValueAsString(ObjectMapper mapper, T object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    private JacksonUtils() {
    }
}

