/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.grok;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.grok.GrokLine;
import com.appdynamics.common.util.regex.RegexHelper;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrokLineAst {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokLineAst.class);
    final String name;
    final ValueType suggestedValueType;
    final GrokLineAstItem[] values;

    GrokLineAst(String name, GrokLineAstItem ... values) {
        this(name, ValueType.UNKNOWN, values);
    }

    GrokLineAst(String name, ValueType suggestedValueType, GrokLineAstItem ... values) {
        this.name = name;
        this.suggestedValueType = suggestedValueType;
        this.values = values;
    }

    GrokLine resolve(Map<String, GrokLineAst> asts) {
        return this.resolve((Map<String, GrokLine>)ImmutableMap.of(), asts);
    }

    GrokLine resolve(Map<String, GrokLine> primary, Map<String, GrokLineAst> fallback) {
        GrokLineBuilder scratchpad = new GrokLineBuilder();
        for (GrokLineAstItem value : this.values) {
            if (value instanceof Literal) {
                scratchpad.appendPartial((Literal)value);
                continue;
            }
            if (value instanceof PatternRef) {
                PatternRef from = (PatternRef)value;
                String patternName = from.getPatternName();
                GrokLine referencedGrokLine = primary.get(patternName);
                if (referencedGrokLine == null) {
                    GrokLineAst referencedGrokLineAst = fallback.get(patternName);
                    if (referencedGrokLineAst == null) {
                        throw new IllegalArgumentException("Could not find pattern [" + patternName + "] in the database.");
                    }
                    referencedGrokLine = referencedGrokLineAst.resolve(primary, fallback);
                }
                scratchpad.appendPartial(from.getAliasJavaCompliant(), referencedGrokLine);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type [" + value.getClass().getName() + "]");
        }
        return scratchpad.build(this.suggestedValueType);
    }

    @Generated
    public String toString() {
        return "GrokLineAst(name=" + this.getName() + ", suggestedValueType=" + String.valueOf((Object)this.getSuggestedValueType()) + ", values=" + Arrays.deepToString(this.getValues()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrokLineAst)) {
            return false;
        }
        GrokLineAst other = (GrokLineAst)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ValueType this$suggestedValueType = this.getSuggestedValueType();
        ValueType other$suggestedValueType = other.getSuggestedValueType();
        if (this$suggestedValueType == null ? other$suggestedValueType != null : !((Object)((Object)this$suggestedValueType)).equals((Object)other$suggestedValueType)) {
            return false;
        }
        return Arrays.deepEquals(this.getValues(), other.getValues());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrokLineAst;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ValueType $suggestedValueType = this.getSuggestedValueType();
        result = result * 59 + ($suggestedValueType == null ? 43 : ((Object)((Object)$suggestedValueType)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValues());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ValueType getSuggestedValueType() {
        return this.suggestedValueType;
    }

    @Generated
    public GrokLineAstItem[] getValues() {
        return this.values;
    }

    static abstract class GrokLineAstItem {
        private GrokLineAstItem() {
        }
    }

    private class GrokLineBuilder {
        private final StringBuilder stringBuilder = new StringBuilder();
        private final Map<String, ValueType> aliasAndTypes = new HashMap<String, ValueType>();
        private ValueType inferredValueType;

        GrokLineBuilder() {
        }

        void appendPartial(Literal literal) {
            this.stringBuilder.append(literal.getValue());
            this.appendPartial(ValueType.UNKNOWN);
        }

        void appendPartial(Optional<String> alias, GrokLine grokLine) {
            if (alias.isPresent()) {
                this.stringBuilder.append("(?<").append((String)alias.get()).append('>');
                if (this.aliasAndTypes.containsKey(alias.get())) {
                    throw new ConfigurationException("The alias [" + (String)alias.get() + "] has already been defined in the pattern");
                }
                this.aliasAndTypes.put((String)alias.get(), grokLine.getEffectiveType());
            }
            this.stringBuilder.append(grokLine.getPatternString());
            if (alias.isPresent()) {
                this.stringBuilder.append(')');
            }
            this.appendPartial(grokLine.getEffectiveType());
        }

        void appendPartial(ValueType valueType) {
            if (this.inferredValueType == null) {
                this.inferredValueType = valueType;
            } else {
                ValueType newInferredType = this.inferredValueType.and(valueType);
                if (this.inferredValueType != newInferredType && log.isDebugEnabled()) {
                    log.debug("Grok line [{}] was considered to be of type [{}] but with the addition of [{}] it will now be treated as [{}]", new Object[]{GrokLineAst.this.name, this.inferredValueType, valueType, newInferredType});
                }
                this.inferredValueType = newInferredType;
            }
        }

        GrokLine build(ValueType overrideValueType) {
            ValueType finalValueType = overrideValueType;
            if (overrideValueType == ValueType.UNKNOWN && this.inferredValueType != null && overrideValueType != this.inferredValueType) {
                log.debug("It could be inferred that the type is [{}] for pattern [{}]", (Object)this.inferredValueType, (Object)GrokLineAst.this.name);
                finalValueType = this.inferredValueType;
            }
            return new GrokLine(GrokLineAst.this.name, this.stringBuilder.toString(), this.aliasAndTypes, finalValueType);
        }
    }

    static class Literal
    extends GrokLineAstItem {
        final String value;

        Literal(String value) {
            this.value = value;
        }

        @Generated
        public String toString() {
            return "GrokLineAst.Literal(value=" + this.getValue() + ")";
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Literal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    static class PatternRef
    extends GrokLineAstItem {
        final String patternName;
        final Optional<String> alias;
        final Optional<String> aliasJavaCompliant;

        PatternRef(String patternName) {
            this(patternName, (Optional<String>)Optional.absent());
        }

        PatternRef(String patternName, String alias) {
            this(patternName, (Optional<String>)Optional.fromNullable((Object)alias));
        }

        PatternRef(String patternName, Optional<String> alias) {
            this.patternName = patternName;
            this.alias = alias;
            this.aliasJavaCompliant = Optional.fromNullable(alias.isPresent() ? RegexHelper.removePunctuations((String)alias.get()) : null);
        }

        @Generated
        public String toString() {
            return "GrokLineAst.PatternRef(patternName=" + this.getPatternName() + ", alias=" + String.valueOf(this.getAlias()) + ", aliasJavaCompliant=" + String.valueOf(this.getAliasJavaCompliant()) + ")";
        }

        @Generated
        public String getPatternName() {
            return this.patternName;
        }

        @Generated
        public Optional<String> getAlias() {
            return this.alias;
        }

        @Generated
        public Optional<String> getAliasJavaCompliant() {
            return this.aliasJavaCompliant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatternRef)) {
                return false;
            }
            PatternRef other = (PatternRef)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$patternName = this.getPatternName();
            String other$patternName = other.getPatternName();
            if (this$patternName == null ? other$patternName != null : !this$patternName.equals(other$patternName)) {
                return false;
            }
            Optional<String> this$alias = this.getAlias();
            Optional<String> other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            Optional<String> this$aliasJavaCompliant = this.getAliasJavaCompliant();
            Optional<String> other$aliasJavaCompliant = other.getAliasJavaCompliant();
            return !(this$aliasJavaCompliant == null ? other$aliasJavaCompliant != null : !this$aliasJavaCompliant.equals(other$aliasJavaCompliant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PatternRef;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $patternName = this.getPatternName();
            result = result * 59 + ($patternName == null ? 43 : $patternName.hashCode());
            Optional<String> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            Optional<String> $aliasJavaCompliant = this.getAliasJavaCompliant();
            result = result * 59 + ($aliasJavaCompliant == null ? 43 : $aliasJavaCompliant.hashCode());
            return result;
        }
    }
}

