/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.grok;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.Parameters;
import com.appdynamics.common.util.regex.RegexHelper;
import com.appdynamics.common.util.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokLine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokLine.class);
    final String name;
    final String patternString;
    final Map<String, ValueType> aliasAndTypes;
    final ValueType effectiveType;

    GrokLine(String name, String patternString, Map<String, ValueType> aliasAndTypes, ValueType effectiveType) {
        this.name = name;
        this.patternString = patternString;
        this.aliasAndTypes = aliasAndTypes;
        this.effectiveType = effectiveType;
    }

    RegexPattern compile(Map<String, String> javaAndGrokAliases, Map<String, String> javaAndGrokAliasesInDefinition) {
        Pattern compiledPattern;
        try {
            compiledPattern = Pattern.compile(this.patternString);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException(String.format("The converted pattern [%s] contains [%s] at index [%d] of the converted pattern", this.patternString, e.getDescription(), e.getIndex()), e);
        }
        Map<String, Integer> names = RegexHelper.namedGroups(compiledPattern);
        String[] aliases = new String[names.size()];
        String[] aliasesJavaCompliant = new String[names.size()];
        int[] aliasGroupIds = new int[names.size()];
        ValueType[] valueTypes = new ValueType[names.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : names.entrySet()) {
            String key;
            aliasesJavaCompliant[i] = key = entry.getKey();
            aliases[i] = Parameters.firstNonNull(javaAndGrokAliasesInDefinition.get(key), javaAndGrokAliases.get(key), key);
            aliasGroupIds[i] = entry.getValue();
            valueTypes[i] = ValueType.defaultIfNull(this.aliasAndTypes.get(key));
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug("Pattern [{}] has {} Named Capture Groups, {} aliases and their Java compliant aliases {}", new Object[]{this.patternString, names, Arrays.asList(aliases), Arrays.asList(aliasesJavaCompliant)});
        }
        return new RegexPattern(compiledPattern, aliases, aliasesJavaCompliant, aliasGroupIds, valueTypes);
    }

    @Generated
    public String toString() {
        return "GrokLine(name=" + this.getName() + ", patternString=" + this.getPatternString() + ", aliasAndTypes=" + String.valueOf(this.getAliasAndTypes()) + ", effectiveType=" + String.valueOf((Object)this.getEffectiveType()) + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPatternString() {
        return this.patternString;
    }

    @Generated
    public Map<String, ValueType> getAliasAndTypes() {
        return this.aliasAndTypes;
    }

    @Generated
    public ValueType getEffectiveType() {
        return this.effectiveType;
    }
}

