/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.appdynamics.common.util.exception.CircuitBreaker;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThresholdCircuitBreaker
extends CircuitBreaker {
    final long minErrorCount;
    final double maxErrorRatio;
    final long maxErrorCount;

    ThresholdCircuitBreaker(long minErrorCount, double maxErrorRatio, long maxErrorCount) {
        Preconditions.checkArgument((minErrorCount > 0L ? 1 : 0) != 0, (Object)"Min error count should be greater than 0");
        Preconditions.checkArgument((minErrorCount <= maxErrorCount ? 1 : 0) != 0, (Object)"Min error count should be less than or equal to max");
        Preconditions.checkArgument((maxErrorRatio > 0.0 ? 1 : 0) != 0, (Object)"Min error ratio should be greater than 0.0");
        this.minErrorCount = minErrorCount;
        this.maxErrorRatio = maxErrorRatio;
        this.maxErrorCount = maxErrorCount;
    }

    public final long getMinErrorCount() {
        return this.minErrorCount;
    }

    public final double getMaxErrorRatio() {
        return this.maxErrorRatio;
    }

    public final long getMaxErrorCount() {
        return this.maxErrorCount;
    }

    @Override
    protected boolean isCircuitDown(long success, long error) {
        if (error < this.minErrorCount) {
            return false;
        }
        double pct = (double)error / (double)(success + error);
        return error >= this.maxErrorCount || pct - this.maxErrorRatio >= 0.001;
    }
}

