/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.exception.CircuitBreaker;
import com.appdynamics.common.util.exception.ResettableCircuitBreaker;
import com.appdynamics.common.util.exception.ResettableCircuitBreakerConfiguration;
import com.appdynamics.common.util.exception.ThresholdCircuitBreaker;
import com.appdynamics.common.util.exception.ThresholdCircuitBreakerConfiguration;

public abstract class CircuitBreakers {
    private CircuitBreakers() {
    }

    public static CircuitBreaker newCircuitBreaker() {
        return new CircuitBreaker();
    }

    public static ResettableCircuitBreaker newCircuitBreaker(ResettableCircuitBreakerConfiguration config) {
        TimeUnitConfiguration downTime = config.getDownTime();
        TimeUnitConfiguration metricLifeTime = config.getLifeTime();
        ThresholdCircuitBreakerConfiguration thresholdConfig = config.getThreshold();
        return new ResettableCircuitBreaker(downTime.toMilliseconds(), metricLifeTime.toMilliseconds(), thresholdConfig.getMinErrorCount(), thresholdConfig.getMaxErrorRatio().doubleValue(), thresholdConfig.getMaxErrorCount());
    }

    public static ThresholdCircuitBreaker newCircuitBreaker(ThresholdCircuitBreakerConfiguration cfg) {
        return new ThresholdCircuitBreaker(cfg.getMinErrorCount(), cfg.getMaxErrorRatio().doubleValue(), cfg.getMaxErrorCount());
    }

    public static ThresholdCircuitBreaker newCircuitBreaker(double maxErrorRatio) {
        return new ThresholdCircuitBreaker(1L, maxErrorRatio, Long.MAX_VALUE);
    }

    public static ThresholdCircuitBreaker newCircuitBreaker(long minErrorCount, double maxErrorRatio, long maxErrorCount) {
        return new ThresholdCircuitBreaker(minErrorCount, maxErrorRatio, maxErrorCount);
    }
}

