/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.exception;

import com.appdynamics.common.util.exception.TooManyErrorsException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CircuitBreaker {
    private final AtomicLong successCount = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();

    CircuitBreaker() {
    }

    public final long getSuccessCount() {
        return this.successCount.get();
    }

    public final long getErrorCount() {
        return this.errorCount.get();
    }

    public final long addSuccessCount(long count) {
        return this.successCount.addAndGet(count);
    }

    public final long addErrorCount(long count) {
        long success = this.successCount.get();
        long error = this.errorCount.addAndGet(count);
        this.checkCircuit(success, error);
        return error;
    }

    public void resetCounts() {
        this.successCount.set(0L);
        this.errorCount.set(0L);
    }

    public final void checkCircuit() {
        this.checkCircuit(this.getSuccessCount(), this.getErrorCount());
    }

    private void checkCircuit(long success, long error) {
        if (this.isCircuitDown(success, error)) {
            throw new TooManyErrorsException(success, error);
        }
    }

    protected boolean isCircuitDown(long success, long error) {
        return error > success;
    }
}

