/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.datetime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class TimeUnitConfiguration {
    @Min(value=1L)
    private @Min(value=1L) long time;
    @NotNull
    @Valid
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public TimeUnitConfiguration() {
    }

    @JsonCreator
    public TimeUnitConfiguration(@JsonProperty(value="time") long time, @JsonProperty(value="timeUnit") TimeUnit timeUnit) {
        this.time = time;
        this.timeUnit = timeUnit;
    }

    public long toMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.time, this.timeUnit);
    }

    public String toString() {
        return this.time + " " + this.timeUnit.name().toLowerCase();
    }

    public static TimeUnitConfiguration valueOf(String timeUnitConfigurationStr) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)timeUnitConfigurationStr) ? 1 : 0) != 0);
        Iterable timeAndUnit = Splitter.on((String)" ").omitEmptyStrings().trimResults().split((CharSequence)timeUnitConfigurationStr);
        Preconditions.checkArgument((Iterables.size((Iterable)timeAndUnit) == 2 ? 1 : 0) != 0);
        String timeStr = (String)Iterables.getFirst((Iterable)timeAndUnit, null);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)timeStr) ? 1 : 0) != 0);
        Long time = Long.valueOf(timeStr);
        Preconditions.checkArgument((time != null ? 1 : 0) != 0);
        String timeUnitStr = (String)Iterables.getLast((Iterable)timeAndUnit, null);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)timeUnitStr) ? 1 : 0) != 0);
        TimeUnit timeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
        return new TimeUnitConfiguration(time, timeUnit);
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public void setTime(long time) {
        this.time = time;
    }

    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeUnitConfiguration)) {
            return false;
        }
        TimeUnitConfiguration other = (TimeUnitConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeUnitConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }
}

