/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.datetime;

import com.appdynamics.common.util.datetime.Ticker;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@ThreadSafe
public class TimeKeeper {
    public static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final DateTimeFormatter UTC_ISO_8601_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private final Ticker ticker;
    private volatile CachedTimes cachedTimes;

    public TimeKeeper(Ticker ticker) {
        this.ticker = ticker;
        this.tryUpdateCachedTimes();
    }

    public TimeKeeper() {
        this(new Ticker());
    }

    public static DateTime utcTime(long millis) {
        return new DateTime(millis, DateTimeZone.UTC);
    }

    public static DateTime currentUtcTime() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }

    public static DateTimeFormatter utcIso8601Formatter() {
        return UTC_ISO_8601_FORMATTER;
    }

    public static String utcTimeIso8601(long utcMillis) {
        return UTC_ISO_8601_FORMATTER.print(utcMillis);
    }

    public static String currentUtcTimeIso8601() {
        return TimeKeeper.utcTimeIso8601(System.currentTimeMillis());
    }

    private static DateTime minute(long utcMillis) {
        return TimeKeeper.utcTime(utcMillis).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public static DateTime currentMinute() {
        return TimeKeeper.minute(System.currentTimeMillis());
    }

    private void tryUpdateCachedTimes() {
        long now = this.ticker.currentTimeMillis();
        if (this.cachedTimes == null || now >= this.cachedTimes.expiresAtMillis) {
            DateTime nowMinute = TimeKeeper.minute(now);
            this.cachedTimes = new CachedTimes(nowMinute, nowMinute.plusMinutes(1).getMillis());
        }
    }

    public DateTime getPreviousMinute() {
        this.tryUpdateCachedTimes();
        return this.cachedTimes.prevMinute;
    }

    public DateTime getCurrentDay() {
        this.tryUpdateCachedTimes();
        return this.cachedTimes.currDay;
    }

    public DateTime getCurrentMinute() {
        this.tryUpdateCachedTimes();
        return this.cachedTimes.currMinute;
    }

    private static class CachedTimes {
        final DateTime prevMinute;
        final DateTime currDay;
        final DateTime currMinute;
        final long expiresAtMillis;

        private CachedTimes(DateTime currMinute, long expiresAtMillis) {
            this.prevMinute = currMinute.minusMinutes(1);
            this.currDay = currMinute.withTimeAtStartOfDay();
            this.currMinute = currMinute;
            this.expiresAtMillis = expiresAtMillis;
        }
    }
}

