/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.datetime;

import lombok.Generated;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastDateTimeParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FastDateTimeParser.class);
    public static final int MATCH_FAILURE = -1;
    private final DateTimeParser parser;
    private final DateTimeParserBucket bucket;
    private final Object resetState;
    private String currentText;
    private int currentPosition;
    private boolean overrideTimeZone;
    private DateTimeZone timeZone;

    public FastDateTimeParser(DateTimeFormatter formatter) {
        this.parser = formatter.getParser();
        this.bucket = new DateTimeParserBucket(0L, formatter.getChronology(), formatter.getLocale(), formatter.getPivotYear(), formatter.getDefaultYear());
        this.overrideTimeZone = false;
        if (formatter.getZone() != null) {
            this.bucket.setZone(formatter.getZone());
            this.timeZone = formatter.getZone();
            this.overrideTimeZone = true;
        }
        this.resetState = this.bucket.saveState();
    }

    public void reset() {
        this.reset("");
    }

    public void reset(String text) {
        this.currentText = text;
        this.currentPosition = 0;
    }

    public long next() {
        long returnVal = -1L;
        boolean trace = log.isTraceEnabled();
        int length = this.currentText.length();
        while (this.currentPosition < length) {
            block5: {
                this.bucket.restoreState(this.resetState);
                int nextPosition = this.parser.parseInto(this.bucket, this.currentText, this.currentPosition);
                if (nextPosition >= this.currentPosition) {
                    try {
                        if (this.overrideTimeZone) {
                            this.bucket.setOffset(null);
                            this.bucket.setZone(this.timeZone);
                        }
                        returnVal = this.bucket.computeMillis(true, this.currentText.substring(this.currentPosition, nextPosition));
                        this.currentPosition = nextPosition;
                        break;
                    }
                    catch (IllegalFieldValueException e) {
                        if (!trace) break block5;
                        log.error("Error occurred while parsing string [" + this.currentText + "] at position [" + this.currentPosition + "]", (Throwable)e);
                    }
                }
            }
            ++this.currentPosition;
        }
        return returnVal;
    }
}

