/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.configuration.ErrorMessageBuilder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import jakarta.validation.ConstraintViolation;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringEscapeUtils;

public class JsonErrorMessageBuilder<T>
implements ErrorMessageBuilder<T> {
    @Override
    public String buildErrorMessage(T configuration, Set<ConstraintViolation<T>> errors) {
        if (configuration == null || errors == null || errors.isEmpty()) {
            return "";
        }
        ImmutableList.Builder errorDetailsBuilder = ImmutableList.builder();
        for (ConstraintViolation<T> error : errors) {
            errorDetailsBuilder.add((Object)new ErrorDetails(error.getPropertyPath().toString(), error.getMessage()));
        }
        ImmutableList errorDetails = errorDetailsBuilder.build();
        return JsonErrorMessageBuilder.serializeToJson((ImmutableList<ErrorDetails>)errorDetails);
    }

    public static String serializeErrorToJson(String location, String errorMessage) {
        return JsonErrorMessageBuilder.serializeToJson((ImmutableList<ErrorDetails>)ImmutableList.of((Object)new ErrorDetails(location, errorMessage)));
    }

    private static String serializeToJson(ImmutableList<ErrorDetails> errorDetails) {
        try {
            return CommonReader.DEFAULT_JSON_MAPPER.writeValueAsString(errorDetails);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error occurred while serializing the following error details into JSON format\n" + errorDetails.toString(), e);
        }
    }

    private static class ErrorDetails {
        private final String location;
        private final String errorMessage;

        @JsonCreator
        private ErrorDetails(@JsonProperty(value="location") String location, @JsonProperty(value="errorMessage") String errorMessage) {
            this.location = StringEscapeUtils.escapeJson((String)location);
            this.errorMessage = StringEscapeUtils.escapeJson((String)errorMessage);
        }

        @Generated
        public String toString() {
            return "JsonErrorMessageBuilder.ErrorDetails(location=" + this.getLocation() + ", errorMessage=" + this.getErrorMessage() + ")";
        }

        @Generated
        public String getLocation() {
            return this.location;
        }

        @Generated
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

