/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.DefaultErrorMessageBuilder;
import com.appdynamics.common.util.configuration.ErrorMessageBuilder;
import com.appdynamics.common.util.configuration.Parameters;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.google.common.reflect.TypeToken;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonReader.class);
    protected static final YAMLFactory YAML_FACTORY = new YAMLFactory();
    public static final ObjectMapper DEFAULT_YAML_MAPPER = CommonReader.newYamlObjectMapper();
    public static final ObjectMapper DEFAULT_JSON_MAPPER = CommonReader.newJsonObjectMapper();
    private static final ErrorMessageBuilder<Object> DEFAULT_ERROR_MESSAGE_BUILDER = new DefaultErrorMessageBuilder<Object>();

    protected CommonReader() {
    }

    public static <T> T readFrom(Class<T> klass, InputStream source) throws IOException {
        Objects.requireNonNull(source, "Source cannot be null");
        Object value = DEFAULT_YAML_MAPPER.readValue(source, klass);
        CommonReader.validate(value);
        return (T)value;
    }

    public static <T> T readFrom(final TypeToken<T> typeReference, InputStream source) {
        Object value;
        Objects.requireNonNull(source, "Source cannot be null");
        try {
            TypeReference tr = new TypeReference<T>(){

                public Type getType() {
                    return typeReference.getType();
                }
            };
            value = DEFAULT_YAML_MAPPER.readValue(source, tr);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        CommonReader.validate(value);
        return (T)value;
    }

    public static <T> T readFrom(Class<T> klass, Object intermediateSource) {
        Object value;
        Objects.requireNonNull(intermediateSource, "Source cannot be null");
        try {
            value = DEFAULT_YAML_MAPPER.convertValue(intermediateSource, klass);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        CommonReader.validate(value);
        return (T)value;
    }

    public static <T> T readFrom(final TypeToken<T> typeReference, Object intermediateSource) {
        Object value;
        Objects.requireNonNull(intermediateSource, "Source cannot be null");
        try {
            TypeReference tr = new TypeReference<T>(){

                public Type getType() {
                    return typeReference.getType();
                }
            };
            value = DEFAULT_YAML_MAPPER.convertValue(intermediateSource, tr);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        CommonReader.validate(value);
        return (T)value;
    }

    protected static ObjectMapper newObjectMapper(JsonFactory factory) {
        ObjectMapper mapper = factory != null ? new ObjectMapper(factory) : new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new AfterburnerModule());
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        SimpleModule module = CommonReader.getCaseInsensitiveEnumSerDeserModule();
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static SimpleModule getCaseInsensitiveEnumSerDeserModule() {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new JsonDeserializer<Enum>(){

                    public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                        Object value;
                        Class rawClass = type.getRawClass();
                        try {
                            value = Enum.valueOf(rawClass, jp.getValueAsString().toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            value = EnumResolver.constructUnsafeUsingToString((Class)rawClass, null).findEnum(jp.getValueAsString());
                        }
                        if (value == null) {
                            log.warn("Unable to deserialize enum [{}] with value [{}]", (Object)rawClass, (Object)jp.getValueAsString());
                        }
                        return value;
                    }
                };
            }
        });
        module.addSerializer(Enum.class, (JsonSerializer)new StdSerializer<Enum>(Enum.class){

            public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.toString());
            }
        });
        return module;
    }

    protected static ObjectMapper newJsonObjectMapper() {
        return CommonReader.newObjectMapper(null);
    }

    protected static ObjectMapper newYamlObjectMapper() {
        return CommonReader.newObjectMapper((JsonFactory)YAML_FACTORY);
    }

    public static <T> void validate(T config) {
        CommonReader.validate(config, DEFAULT_ERROR_MESSAGE_BUILDER);
    }

    public static <T> void validate(T config, ErrorMessageBuilder<T> customErrorMessageBuilder) {
        Set errors;
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        if (config == null) {
            return;
        }
        try {
            errors = validator.validate(config, new Class[0]);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        if (!errors.isEmpty()) {
            String errorMessage = customErrorMessageBuilder.buildErrorMessage(config, errors);
            throw new ConfigurationException(errorMessage);
        }
    }

    public static String toYaml(Object anything) {
        try {
            String s = DEFAULT_YAML_MAPPER.writeValueAsString(anything);
            String startingComment = "---\n";
            return s.startsWith(startingComment) ? s.substring(startingComment.length()) : s;
        }
        catch (JsonProcessingException e) {
            log.warn("Error occurred while transforming the object to a formatted YML string [" + String.valueOf(anything) + "]", (Throwable)e);
            return Parameters.asString(anything, "<unavailable>");
        }
    }
}

