/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import com.appdynamics.common.util.concurrent.RepeatableTask;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRepeatableTaskRunner
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRepeatableTaskRunner.class);
    private final RepeatableTask task;

    public SimpleRepeatableTaskRunner(RepeatableTask task) {
        this.task = task;
    }

    @Override
    public void run() {
        String taskName = this.task.getClass().getName();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Long delayUntilNextExecution = this.task.call();
                if (delayUntilNextExecution == null) {
                    return;
                }
                Thread.sleep(delayUntilNextExecution);
            }
            catch (InterruptedException e) {
                log.warn("Thread interrupted while executing task [" + taskName + "]", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("Finished executing task [{}]", (Object)taskName);
    }
}

