/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PooledReference<POOLED_OBJ> {
    private final POOLED_OBJ pooledObject;
    private final Function<POOLED_OBJ, Void> cleaner;
    private final AtomicInteger referenceCount;
    private final AtomicBoolean markedForCleanup;

    public PooledReference(POOLED_OBJ pooledObject, Function<POOLED_OBJ, Void> cleaner) {
        this.pooledObject = Preconditions.checkNotNull(pooledObject);
        this.cleaner = (Function)Preconditions.checkNotNull(cleaner);
        this.referenceCount = new AtomicInteger(0);
        this.markedForCleanup = new AtomicBoolean(false);
    }

    public POOLED_OBJ borrow() {
        if (this.markedForCleanup.get()) {
            return null;
        }
        int currentCount = this.referenceCount.incrementAndGet();
        if (this.markedForCleanup.get() || currentCount <= 0) {
            return null;
        }
        return this.pooledObject;
    }

    public void dropOff(POOLED_OBJ borrowedObject) {
        Preconditions.checkState((borrowedObject == this.pooledObject ? 1 : 0) != 0);
        int currentCount = this.referenceCount.decrementAndGet();
        if (currentCount < 0) {
            throw new IllegalStateException();
        }
        if (currentCount == 0 && this.markedForCleanup.get()) {
            this.attemptCleanup();
        }
    }

    public void markAndAttemptCleanup() {
        if (!this.markedForCleanup.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        this.attemptCleanup();
    }

    private void attemptCleanup() {
        int afterCleanupValue = -1073741824;
        if (this.referenceCount.compareAndSet(0, -1073741824)) {
            this.cleaner.apply(this.pooledObject);
        }
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

