/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

public class ManualResetEvent {
    private final Object monitor = new Object();
    private volatile boolean signaled = false;

    public ManualResetEvent(boolean signaled) {
        this.signaled = signaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSingleEvent() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            while (!this.signaled) {
                this.monitor.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSingleEvent(long timeoutMillis) throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            long timeoutExpires = currentTime + timeoutMillis;
            while (currentTime < timeoutExpires) {
                if (this.signaled) {
                    return true;
                }
                this.monitor.wait(timeoutExpires - currentTime);
                currentTime = System.currentTimeMillis();
            }
            return this.signaled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        Object object = this.monitor;
        synchronized (object) {
            this.signaled = true;
            this.monitor.notifyAll();
        }
    }

    public void clear() {
        this.signaled = false;
    }

    public boolean get() {
        return this.signaled;
    }
}

