/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.concurrent;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public final class Callables {
    private Callables() {
    }

    public static <V> MdcForwardingCallable<V> getMdcForwardingCallable(Callable<V> callable) {
        return callable instanceof MdcForwardingCallable ? (MdcForwardingCallable)callable : new MdcForwardingCallable<V>(callable);
    }

    static class MdcForwardingCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final Map<String, String> context;

        private MdcForwardingCallable(Callable<V> delegate) {
            Preconditions.checkArgument((delegate != null ? 1 : 0) != 0);
            this.delegate = delegate;
            this.context = MDC.getCopyOfContextMap();
        }

        @Override
        public V call() throws Exception {
            Map originalContext = MDC.getCopyOfContextMap();
            if (this.context != null) {
                MDC.setContextMap(this.context);
            }
            try {
                V v = this.delegate.call();
                return v;
            }
            finally {
                if (this.context != null) {
                    MDC.setContextMap((Map)originalContext);
                }
            }
        }
    }
}

