/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.codec;

import com.appdynamics.common.io.NioByteArrayOutputStream;
import com.appdynamics.common.util.configuration.CommonReader;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Json {
    private Json() {
    }

    public static Encoder newEncoder() {
        return new Encoder();
    }

    public static Decoder newDecoder() {
        return new Decoder();
    }

    public static Walker newWalker() {
        return new Walker();
    }

    public static Pair<Map<String, Object>, Object> parseJsonAndRead(String jsonUtf8, String ... path) throws IOException {
        Map map;
        try (ByteArrayInputStream is = new ByteArrayInputStream(jsonUtf8.getBytes(Charsets.UTF_8));){
            map = CommonReader.readFrom(Map.class, (InputStream)is);
        }
        Object item = Json.navigateAndRead(map, path);
        return new ImmutablePair((Object)map, item);
    }

    public static Object navigateAndRead(Map<String, Object> map, String ... path) {
        Object o = map;
        for (String pathElement : path) {
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("The path element [" + pathElement + "] does not appear to be a map");
            }
            o = o.get(pathElement);
        }
        if (path.length == 0) {
            o = null;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ScanResult> scanChildrenOfArray(Walker walker, byte[] jsonArray, int offset, int length) throws IOException {
        ArrayList<ScanResult> children = new ArrayList<ScanResult>(8);
        walker.startWalk(jsonArray, offset, length);
        try {
            if (walker.next()) {
                if (!walker.isArrayStart()) {
                    throw new IllegalArgumentException("The JSON structure does not contain a top level array");
                }
                if (walker.next()) {
                    while (walker.isArrayOrObjectStart()) {
                        children.add(walker.scanAndSkipArrayOrObject());
                    }
                }
                if (!walker.isArrayEnd()) {
                    throw new IllegalArgumentException("The top level array either does not end as an array or seems to have children that are not themselves objects or arrays");
                }
            }
        }
        finally {
            walker.endWalk();
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTopLevelFields(Walker walker, byte[] jsonBytes, int offset, int length, Map<String, JsonNode> fieldNamesToReadInto) throws IOException {
        walker.startWalk(jsonBytes, offset, length);
        try {
            int fieldNamesToRead = fieldNamesToReadInto.size();
            Preconditions.checkArgument((fieldNamesToRead > 0 ? 1 : 0) != 0, (Object)"The field names to read must be provided");
            if (walker.next()) {
                String fieldNameStarted = null;
                Boolean optionalHasNext = null;
                while (fieldNamesToRead > 0 && (optionalHasNext != null && optionalHasNext.booleanValue() || walker.next())) {
                    String walkerString;
                    if (walker.isFieldStart() && fieldNamesToReadInto.containsKey(walkerString = walker.readAsString())) {
                        fieldNameStarted = walkerString;
                    } else {
                        if (fieldNameStarted != null) {
                            Pair<JsonNode, Boolean> pair = walker.consumeAndReadAsTree();
                            fieldNamesToReadInto.put(fieldNameStarted, (JsonNode)pair.getLeft());
                            --fieldNamesToRead;
                            fieldNameStarted = null;
                            optionalHasNext = (Boolean)pair.getRight();
                            continue;
                        }
                        if (walker.isArrayOrObjectStart()) {
                            optionalHasNext = walker.scanAndSkipArrayOrObject().hasMore();
                            continue;
                        }
                    }
                    optionalHasNext = null;
                }
            }
        }
        finally {
            walker.endWalk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfNestedFieldWithExpectedValueExist(Walker walker, byte[] jsonBytes, int offset, int length, String parentName, String childName, String expectedValue) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parentName) ? 1 : 0) != 0, (Object)"Parent field name can't be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)childName) ? 1 : 0) != 0, (Object)"Child field name can't be null or empty");
        walker.startWalk(jsonBytes, offset, length);
        try {
            String parentFieldName = null;
            while (walker.next()) {
                String walkerString;
                if (walker.isFieldStart() && parentName.equals(walkerString = walker.readAsString())) {
                    parentFieldName = walkerString;
                    continue;
                }
                if (parentFieldName == null) continue;
                Preconditions.checkState((boolean)walker.isArrayOrObjectStart(), (Object)"Field is not a parent");
                boolean walkingFieldAtOneLevelDeep = false;
                while (walker.next()) {
                    if (walker.isArrayOrObjectEnd()) {
                        walkingFieldAtOneLevelDeep = false;
                        if (walker.next() && !walker.isObjectStart()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (walkingFieldAtOneLevelDeep && walker.isArrayOrObjectStart()) {
                        walker.scanAndSkipArrayOrObject();
                    }
                    if (!walker.isFieldStart()) continue;
                    walkingFieldAtOneLevelDeep = true;
                    if (!childName.equals(walker.readAsString())) continue;
                    walker.next();
                    if (!Objects.equals(expectedValue, walker.readAsString())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            walker.endWalk();
        }
        return false;
    }

    public static final class Encoder {
        private final HashMap<String, Object> reusableMap = new HashMap();
        private final NioByteArrayOutputStream reusableBaos = new NioByteArrayOutputStream(512);
        private final ObjectMapper reusableObjectMapper = CommonReader.DEFAULT_JSON_MAPPER;

        Encoder() {
        }

        public Map<String, Object> startEncode() {
            this.abortEncode();
            return this.reusableMap;
        }

        public void encodeBoolean(String fieldName, boolean value) throws IOException {
            this.reusableMap.put(fieldName, value);
        }

        public void encodeString(String fieldName, String value) throws IOException {
            this.reusableMap.put(fieldName, value);
        }

        public void encodeInt(String fieldName, int value) throws IOException {
            this.reusableMap.put(fieldName, value);
        }

        public void encodeLong(String fieldName, long value) throws IOException {
            this.reusableMap.put(fieldName, value);
        }

        public void encodeDouble(String fieldName, double value) throws IOException {
            this.reusableMap.put(fieldName, value);
        }

        public void abortEncode() {
            this.reusableBaos.reset();
            if (this.reusableMap.size() > 0) {
                this.reusableMap.clear();
            }
        }

        public ByteBuffer endEncode() throws IOException {
            if (this.reusableMap.size() == 0) {
                throw new IllegalArgumentException("There is no data to encode");
            }
            try {
                this.reusableObjectMapper.writeValue((OutputStream)this.reusableBaos, this.reusableMap);
            }
            finally {
                this.reusableMap.clear();
            }
            return this.reusableBaos.bufferView();
        }
    }

    public static final class Decoder {
        private JsonNode rootNode;

        Decoder() {
        }

        public void startDecode(ByteBuffer arrayBackedByteBuffer) throws IOException {
            if (!arrayBackedByteBuffer.hasArray()) {
                throw new IllegalArgumentException("Only byte buffers with underlying arrays are supported");
            }
            byte[] bytes = arrayBackedByteBuffer.array();
            int offset = arrayBackedByteBuffer.position();
            int length = arrayBackedByteBuffer.remaining();
            if (length == 0) {
                throw new IllegalArgumentException("The byte buffer does not have any content to read from");
            }
            this.startDecode(bytes, offset, length);
        }

        public void startDecode(byte[] bytes, int offset, int length) throws IOException {
            JsonFactory jsonFactory = new JsonFactory((ObjectCodec)CommonReader.DEFAULT_JSON_MAPPER);
            try (JsonParser jsonParser = jsonFactory.createParser(bytes, offset, offset + length);){
                this.rootNode = (JsonNode)jsonParser.readValueAsTree();
            }
        }

        public boolean decodeBoolean(String fieldName) throws IOException {
            return this.rootNode.get(fieldName).asBoolean();
        }

        public String decodeString(String fieldName) throws IOException {
            return this.rootNode.get(fieldName).asText();
        }

        public int decodeInt(String fieldName) throws IOException {
            return this.rootNode.get(fieldName).asInt();
        }

        public long decodeLong(String fieldName) throws IOException {
            return this.rootNode.get(fieldName).asLong();
        }

        public double decodeDouble(String fieldName) throws IOException {
            return this.rootNode.get(fieldName).asDouble();
        }

        public void endDecode() {
            this.rootNode = null;
        }
    }

    public static final class Walker {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Walker.class);
        private final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)CommonReader.DEFAULT_JSON_MAPPER);
        private byte[] bytes;
        private JsonParser jsonParser;
        private int nestingDepth;

        Walker() {
            this.reset();
        }

        private void reset() {
            this.bytes = null;
            this.jsonParser = null;
            this.nestingDepth = 0;
        }

        private void maintainNestingDepth(JsonToken optToken) {
            if (optToken != null) {
                switch (optToken) {
                    case START_ARRAY: 
                    case START_OBJECT: {
                        this.pushNestingDepth();
                        break;
                    }
                    case END_ARRAY: 
                    case END_OBJECT: {
                        this.popNestingDepth();
                        break;
                    }
                }
            } else {
                this.popNestingDepth();
            }
        }

        private void pushNestingDepth() {
            ++this.nestingDepth;
        }

        private void popNestingDepth() {
            if (this.nestingDepth > 0) {
                --this.nestingDepth;
            }
        }

        public void startWalk(ByteBuffer arrayBackedByteBuffer) throws IOException {
            if (!arrayBackedByteBuffer.hasArray()) {
                throw new IllegalArgumentException("Only byte buffers with underlying arrays are supported");
            }
            byte[] bytes = arrayBackedByteBuffer.array();
            int offset = arrayBackedByteBuffer.position();
            int length = arrayBackedByteBuffer.remaining();
            this.startWalk(bytes, offset, length);
        }

        public void startWalk(byte[] bytes, int offset, int length) throws IOException {
            if (length == 0) {
                throw new IllegalArgumentException("The byte array does not have any content to read from");
            }
            this.jsonParser = this.jsonFactory.createParser(bytes, offset, length);
            this.bytes = bytes;
        }

        public boolean next() throws IOException {
            JsonToken token = this.jsonParser.nextToken();
            this.maintainNestingDepth(token);
            return token != null;
        }

        public int getNestingDepth() {
            return this.nestingDepth;
        }

        public boolean isArrayStart() throws IOException {
            return this.jsonParser.getCurrentToken() == JsonToken.START_ARRAY;
        }

        public boolean isObjectStart() throws IOException {
            return this.jsonParser.getCurrentToken() == JsonToken.START_OBJECT;
        }

        public boolean isArrayOrObjectStart() throws IOException {
            JsonToken token = this.jsonParser.getCurrentToken();
            return token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT;
        }

        public ScanResult scanAndSkipArrayOrObject() throws IOException {
            boolean arrayStart = this.isArrayStart();
            boolean objectStart = this.isObjectStart();
            Preconditions.checkState((arrayStart || objectStart ? 1 : 0) != 0);
            long start = Math.min(this.jsonParser.getCurrentLocation().getByteOffset(), this.jsonParser.getTokenLocation().getByteOffset());
            this.jsonParser.skipChildren();
            Preconditions.checkState((boolean)this.isArrayOrObjectEnd());
            long end = Math.max(this.jsonParser.getCurrentLocation().getByteOffset(), this.jsonParser.getTokenLocation().getByteOffset());
            JsonToken token = this.jsonParser.getCurrentToken();
            this.maintainNestingDepth(token);
            boolean hasNext = this.next();
            char startChar = arrayStart ? (char)'[' : '{';
            char endChar = arrayStart ? (char)']' : '}';
            Pair<Integer, Integer> range = this.refineRange((int)start, (int)end, startChar, endChar);
            return new ScanResult((Integer)range.getLeft(), (Integer)range.getRight(), hasNext);
        }

        private Pair<Integer, Integer> refineRange(int proposedStart, int proposedEnd, char startChar, char endChar) {
            proposedEnd = Math.min(this.bytes.length - 1, proposedEnd);
            for (proposedStart = Math.max(0, proposedStart); proposedStart <= proposedEnd && this.bytes[proposedStart] != startChar; ++proposedStart) {
            }
            while (proposedStart <= proposedEnd && this.bytes[proposedEnd] != endChar) {
                --proposedEnd;
            }
            return new ImmutablePair((Object)proposedStart, (Object)(proposedEnd - proposedStart + 1));
        }

        public Pair<JsonNode, Boolean> consumeAndReadAsTree() throws IOException {
            Preconditions.checkState((!this.isArrayOrObjectEnd() ? 1 : 0) != 0);
            boolean popAfterReading = this.isArrayOrObjectStart();
            JsonNode jsonNode = (JsonNode)this.jsonParser.readValueAsTree();
            if (popAfterReading) {
                this.popNestingDepth();
            }
            boolean has = this.next();
            return new ImmutablePair((Object)jsonNode, (Object)has);
        }

        public boolean isArrayEnd() throws IOException {
            return this.jsonParser.getCurrentToken() == JsonToken.END_ARRAY;
        }

        public boolean isObjectEnd() throws IOException {
            return this.jsonParser.getCurrentToken() == JsonToken.END_OBJECT;
        }

        public boolean isArrayOrObjectEnd() throws IOException {
            JsonToken token = this.jsonParser.getCurrentToken();
            return token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT;
        }

        public boolean isFieldStart() throws IOException {
            return this.jsonParser.getCurrentToken() == JsonToken.FIELD_NAME;
        }

        public String readAsString() throws IOException {
            return this.jsonParser.getText();
        }

        public void endWalk() {
            if (this.jsonParser != null) {
                try {
                    this.jsonParser.close();
                }
                catch (IOException e) {
                    log.warn("Error occurred while closing the internal JSON parser", (Throwable)e);
                }
            }
            this.reset();
        }
    }

    public static class ScanResult
    extends MutablePair<Integer, Integer> {
        final boolean more;

        ScanResult(Integer left, Integer right, boolean more) {
            super((Object)left, (Object)right);
            this.more = more;
        }

        public boolean hasMore() {
            return this.more;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanResult)) {
                return false;
            }
            ScanResult other = (ScanResult)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.more == other.more;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScanResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.more ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "Json.ScanResult(super=" + super.toString() + ", more=" + this.more + ")";
        }
    }
}

