/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.codec;

import com.appdynamics.common.io.NioByteArrayOutputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;

public abstract class Binary {
    private Binary() {
    }

    public static Encoder newEncoder() {
        return new Encoder();
    }

    public static Decoder newDecoder() {
        return new Decoder();
    }

    public static class Encoder {
        private final ByteBuffer reusableBBForInt = ByteBuffer.allocate(4);
        private final IntBuffer reusableIB = this.reusableBBForInt.asIntBuffer();

        Encoder() {
        }

        public long encodedLength(List<ByteBuffer> sourceParts) throws IOException {
            if (sourceParts.size() == 0) {
                throw new IOException("There is no content to be encoded");
            }
            long length = 4L;
            int numBuffers = sourceParts.size();
            for (int i = 0; i < numBuffers; ++i) {
                length += 4L;
                ByteBuffer bb = sourceParts.get(i);
                int remaining = bb.remaining();
                if (remaining <= 0) {
                    throw new IOException("Part at position [" + i + "] has no content to be encoded");
                }
                length += (long)remaining;
            }
            return length;
        }

        public long encode(List<ByteBuffer> sourceParts, WritableByteChannel destination) throws IOException {
            ByteBuffer bb;
            int i;
            if (sourceParts.size() == 0) {
                throw new IOException("There is no content to be encoded");
            }
            long writeCount = 0L;
            int numBuffers = sourceParts.size();
            writeCount += (long)this.writeInt(numBuffers, destination);
            for (i = 0; i < numBuffers; ++i) {
                bb = sourceParts.get(i);
                int length = bb.remaining();
                if (length <= 0) {
                    throw new IOException("Part at position [" + i + "] has no content to be encoded");
                }
                writeCount += (long)this.writeInt(length, destination);
            }
            for (i = 0; i < numBuffers; ++i) {
                bb = sourceParts.get(i);
                writeCount += (long)destination.write(bb);
            }
            return writeCount;
        }

        private int writeInt(int i, WritableByteChannel destination) throws IOException {
            this.reusableBBForInt.clear();
            this.reusableIB.clear();
            this.reusableIB.put(i);
            this.reusableBBForInt.position(4);
            this.reusableIB.flip();
            this.reusableBBForInt.flip();
            return destination.write(this.reusableBBForInt);
        }
    }

    public static class Decoder {
        private final ArrayList<Integer> reusableHeaderLengths = new ArrayList();

        Decoder() {
        }

        public List<ByteBuffer> decode(ReadableByteChannel source) throws IOException {
            try (NioByteArrayOutputStream nioBaos = new NioByteArrayOutputStream(1024);){
                try (WritableByteChannel destination = Channels.newChannel(nioBaos);){
                    long numBytes = ByteStreams.copy((ReadableByteChannel)source, (WritableByteChannel)destination);
                    if (numBytes == 0L) {
                        throw new IOException("There is no content to be decoded");
                    }
                }
                ByteBuffer copiedSource = nioBaos.bufferView();
                List<ByteBuffer> list = this.decode(copiedSource, false);
                return list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ByteBuffer> decode(ByteBuffer source, boolean copy) throws IOException {
            if (source.remaining() <= 0) {
                throw new IOException("There is no content to be decoded");
            }
            IntBuffer intsOnlyBufferView = source.asIntBuffer();
            int fromPosition = 0;
            int numHeaders = intsOnlyBufferView.get();
            if (numHeaders <= 0) {
                throw new IOException("Message header count appears to be corrupt");
            }
            fromPosition += 4;
            try {
                this.reusableHeaderLengths.ensureCapacity(numHeaders);
                for (int i = 0; i < numHeaders; ++i) {
                    int headerLength = intsOnlyBufferView.get();
                    if (headerLength <= 0) {
                        throw new IOException("Message header length appears to be corrupt");
                    }
                    this.reusableHeaderLengths.add(headerLength);
                }
                fromPosition += 4 * numHeaders;
                ArrayList<ByteBuffer> results = new ArrayList<ByteBuffer>(numHeaders);
                for (int i = 0; i < numHeaders; ++i) {
                    int bodyLength = this.reusableHeaderLengths.get(i);
                    ByteBuffer body = source.slice();
                    body.position(fromPosition);
                    body.limit(fromPosition + bodyLength);
                    if (copy) {
                        body = body.duplicate();
                    }
                    results.add(body);
                    fromPosition += bodyLength;
                }
                ArrayList<ByteBuffer> arrayList = results;
                return arrayList;
            }
            finally {
                this.reusableHeaderLengths.clear();
            }
        }
    }
}

