/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.grok;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.grok.GrokLineAst;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class GrokParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokParser.class);
    public static final String PREFIX_GROK_LINE_COMMENT = "#";
    public static final String SEP_GROK_LINE_NAME_VALUE = " ";
    public static final String SAMPLE_PATTERN_REF = "%{that-pattern-name:alias}";
    public static final String MSG_EXPECTED_FORMAT = "pattern-name[:type] (literal? / regex? / pattern-name-reference? (%{that-pattern-name:alias}))+";
    static final String LINE_SUFFIX = "(?<lineSuffix>.*)?";
    static final Pattern PATTERN_GROK_LINE = Pattern.compile("(?<linePrefix>.*?)??%\\{(?<patternReference>[_a-zA-Z][_a-zA-Z\\d]*)(?:\\:(?<alias>[_a-zA-Z][_a-zA-Z\\d]*))?\\}(?<lineSuffix>.*)?");
    static final Pattern PATTERN_GROK_ALIAS = Pattern.compile("%\\{[_a-zA-Z][_a-zA-Z\\d]*(?:\\:(?<alias>[_a-zA-Z][_a-zA-Z\\d]*))\\}(?<lineSuffix>.*)?");
    static final Pattern PATTERN_JAVA_ALIAS = Pattern.compile("\\(\\?<(?<alias>[_a-zA-Z][_a-zA-Z\\d]*)>(?<lineSuffix>.*)?");
    static final Pattern PATTERN_NAME = Pattern.compile("(?<patternName>[_a-zA-Z][_a-zA-Z\\d]*?)(?:\\:(?<patternValueType>[_a-zA-Z][_a-zA-Z\\d]*))?");
    static final String PATTERN_GROUP_LINE_PREFIX = "linePrefix";
    static final String PATTERN_GROUP_PATTERN_REF = "patternReference";
    static final String PATTERN_GROUP_ALIAS = "alias";
    static final String PATTERN_GROUP_LINE_SUFFIX = "lineSuffix";

    private GrokParser() {
    }

    public static void parseLines(InputStream utf8Source, Map<String, GrokLineAst> to) throws IOException {
        Set<String> patternNames = to.keySet();
        List lines = IOUtils.readLines((InputStream)utf8Source, (Charset)StandardCharsets.UTF_8);
        int matchCount = 0;
        for (String line : lines) {
            log.trace("Attempting to parse line [{}]", (Object)line);
            GrokLineAst grokLineAst = GrokParser.parseLine(line, patternNames);
            if (grokLineAst == null) continue;
            GrokLineAst oldGrokLineAst = to.put(grokLineAst.name, grokLineAst);
            if (oldGrokLineAst != null) {
                log.info("A previously parsed Grok pattern [{}] has now been overridden", (Object)grokLineAst.name);
            }
            ++matchCount;
        }
        if (matchCount == 0) {
            log.warn("No patterns were found");
        } else {
            log.debug("Processed [{}] patterns", (Object)matchCount);
        }
    }

    public static GrokLineAst parseLine(String line, Set<String> patternNames) {
        if (GrokParser.isGrokComment(line = line.trim())) {
            log.trace("Ignoring line [{}]", (Object)line);
            return null;
        }
        try {
            return GrokParser.parseNonComment(line, patternNames);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error occurred while parsing line [" + line + "]", (Throwable)e);
        }
    }

    public static GrokLineAst parseDefinition(String definition, Set<String> patternNames) {
        String tempRandomKey = "tempKey_" + System.nanoTime();
        String newLine = tempRandomKey + SEP_GROK_LINE_NAME_VALUE + definition;
        return GrokParser.parseLine(newLine, patternNames);
    }

    public static boolean duplicateAliasesExist(String definition) {
        TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String trimmedDefinition = definition.trim();
        if (GrokParser.duplicateGrokAliasesExist(trimmedDefinition, aliases)) {
            return true;
        }
        return GrokParser.duplicateJavaRegexAliasesExist(trimmedDefinition, aliases);
    }

    static boolean duplicateGrokAliasesExist(String definition, Set<String> aliases) {
        if (aliases == null) {
            aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        Matcher reusableMatcher = PATTERN_GROK_ALIAS.matcher("");
        return GrokParser.duplicateAliasesExist(definition, reusableMatcher, aliases);
    }

    static boolean duplicateJavaRegexAliasesExist(String definition, Set<String> aliases) {
        if (aliases == null) {
            aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        Matcher reusableMatcher = PATTERN_JAVA_ALIAS.matcher("");
        return GrokParser.duplicateAliasesExist(definition, reusableMatcher, aliases);
    }

    public static Set<String> getGrokAliases(String grok) {
        TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        GrokParser.duplicateGrokAliasesExist(grok, aliases);
        return aliases;
    }

    public static Set<String> getJavaRegexGroupAliases(String regex) {
        TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        GrokParser.duplicateJavaRegexAliasesExist(regex, aliases);
        return aliases;
    }

    static boolean duplicateAliasesExist(String definition, Matcher reusableMatcher, Set<String> aliases) {
        String candidate = definition;
        boolean duplicatesExist = false;
        while (candidate != null) {
            reusableMatcher.reset(candidate);
            if (!reusableMatcher.find()) break;
            String alias = reusableMatcher.group(PATTERN_GROUP_ALIAS);
            candidate = reusableMatcher.group(PATTERN_GROUP_LINE_SUFFIX);
            if (aliases.add(alias)) continue;
            log.warn("Found duplicate alias [{}]", (Object)alias);
            duplicatesExist = true;
        }
        return duplicatesExist;
    }

    static boolean isGrokComment(String trimmedLine) {
        return trimmedLine.length() == 0 || trimmedLine.startsWith(PREFIX_GROK_LINE_COMMENT);
    }

    static GrokLineAst parseNonComment(String trimmedLine, Set<String> patternNames) {
        int splitAt = trimmedLine.indexOf(SEP_GROK_LINE_NAME_VALUE);
        if (splitAt == -1) {
            log.warn("Line [{}] does not appear to be in the expected format:\n   [pattern-name[:type] (literal? / regex? / pattern-name-reference? (%{that-pattern-name:alias}))+]", (Object)trimmedLine);
            return null;
        }
        String patternNameAndTypeStr = trimmedLine.substring(0, splitAt);
        Pair<String, ValueType> patternNameAndType = GrokParser.parsePatternNameAndType(patternNameAndTypeStr);
        ValueType suggestedValueType = (ValueType)patternNameAndType.getRight();
        LinkedList<Object> grokLineAstItems = new LinkedList<Object>();
        Matcher reusableMatcher = PATTERN_GROK_LINE.matcher("");
        String candidate = trimmedLine.substring(patternNameAndTypeStr.length() + SEP_GROK_LINE_NAME_VALUE.length());
        while (!Strings.isNullOrEmpty((String)candidate)) {
            reusableMatcher.reset(candidate);
            boolean matched = false;
            if (reusableMatcher.find()) {
                String optLinePrefix = reusableMatcher.group(PATTERN_GROUP_LINE_PREFIX);
                String patternReference = reusableMatcher.group(PATTERN_GROUP_PATTERN_REF);
                String optAlias = reusableMatcher.group(PATTERN_GROUP_ALIAS);
                String optLineSuffix = reusableMatcher.group(PATTERN_GROUP_LINE_SUFFIX);
                if (log.isTraceEnabled()) {
                    log.trace("Parsed line\n    Prefix: [{}]\n    Pattern ref: [{}], alias: [{}]\n    Suffix: [{}]", new Object[]{optLinePrefix, patternReference, optAlias, optLineSuffix});
                }
                if (!Strings.isNullOrEmpty((String)optLinePrefix)) {
                    grokLineAstItems.add(new GrokLineAst.Literal(optLinePrefix));
                }
                if (patternNames != null && log.isTraceEnabled() && !patternNames.contains(patternReference)) {
                    log.trace("Pattern reference [{}] could not be resolved", (Object)patternReference);
                }
                grokLineAstItems.add(new GrokLineAst.PatternRef(patternReference, Optional.fromNullable((Object)optAlias)));
                candidate = optLineSuffix;
                matched = true;
            }
            if (matched) continue;
            grokLineAstItems.add(new GrokLineAst.Literal(candidate));
            break;
        }
        GrokLineAst.GrokLineAstItem[] array = grokLineAstItems.toArray(new GrokLineAst.GrokLineAstItem[grokLineAstItems.size()]);
        return new GrokLineAst((String)patternNameAndType.getLeft(), suggestedValueType, array);
    }

    static Pair<String, ValueType> parsePatternNameAndType(String patternNameAndOptType) {
        String patternName = null;
        ValueType patternValueType = ValueType.UNKNOWN;
        Matcher patternNameMatcher = PATTERN_NAME.matcher(patternNameAndOptType);
        if (patternNameMatcher.matches()) {
            patternName = patternNameMatcher.group("patternName");
            String valueType = patternNameMatcher.group("patternValueType");
            if (valueType != null) {
                try {
                    patternValueType = ValueType.valueOf((String)valueType.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException(String.format("The value type [%s] is not recognized. Valid values are [%s]", valueType, Joiner.on((char)'|').join((Iterable)ValueType.VALID_VALUES)), (Throwable)e);
                }
            }
        } else {
            throw new ConfigurationException("The pattern name [" + patternNameAndOptType + "] does not follow the correct syntax 'name[:" + Joiner.on((char)'|').join((Iterable)ValueType.VALID_VALUES) + "]'");
        }
        return new ImmutablePair((Object)patternName, (Object)patternValueType);
    }
}

