/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;

public abstract class Utf8String {
    private Utf8String() {
    }

    public static Decoder newDecoder() {
        return new Decoder();
    }

    public static class Decoder {
        final char[] chars = new char[4096];
        final StringBuilderWriter writer = new StringBuilderWriter(1024);

        Decoder() {
        }

        public String decode(InputStream inputStream) throws IOException {
            StringBuilder sb = this.writer.getBuilder();
            sb.setLength(0);
            try (InputStreamReader in = new InputStreamReader(inputStream, Charsets.UTF_8);){
                long numBytes = IOUtils.copyLarge((Reader)in, (Writer)this.writer, (char[])this.chars);
                assert (numBytes >= 0L);
                this.writer.close();
            }
            return sb.toString();
        }
    }
}

