/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.internal;

public class Constants {
    public static final int NUMBER_OF_THREADS;
    public static final int JVM_MAJOR_VERSION;
    static final OperatingSystem OS;

    static int getJavaMajorVersion(String versionString) {
        String[] parts = versionString.split("\\.");
        int major = Integer.parseInt(parts[0].split("\\D")[0]);
        if (major == 1) {
            major = Integer.parseInt(parts[1].split("\\D")[0]);
        }
        return major;
    }

    static {
        JVM_MAJOR_VERSION = Constants.getJavaMajorVersion(System.getProperty("java.version"));
        String osname = System.getProperty("os.name").toLowerCase();
        OS = osname.contains("mac") || osname.contains("freebsd") ? OperatingSystem.MAC : (osname.contains("linux") ? OperatingSystem.LINUX : OperatingSystem.SOLARIS);
        String threads = System.getProperty("com.zaxxer.nuprocess.threads", "auto");
        NUMBER_OF_THREADS = "auto".equals(threads) ? Math.max(1, Runtime.getRuntime().availableProcessors() / 2) : ("cores".equals(threads) ? Runtime.getRuntime().availableProcessors() : Math.max(1, Integer.parseInt(threads)));
    }

    static enum OperatingSystem {
        MAC,
        LINUX,
        SOLARIS;

    }
}

