/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.codec;

import com.zaxxer.nuprocess.codec.NuCharsetDecoderHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public final class NuCharsetDecoder {
    private final NuCharsetDecoderHandler handler;
    private final CharsetDecoder decoder;
    private final CharBuffer charBuffer;

    public NuCharsetDecoder(NuCharsetDecoderHandler handler, Charset charset) {
        this(handler, charset.newDecoder());
    }

    public NuCharsetDecoder(NuCharsetDecoderHandler handler, CharsetDecoder decoder) {
        this.handler = handler;
        this.decoder = decoder;
        this.charBuffer = CharBuffer.allocate(65536);
    }

    public void onOutput(ByteBuffer buffer, boolean closed) {
        CoderResult coderResult = this.decoder.decode(buffer, this.charBuffer, closed);
        this.charBuffer.flip();
        this.handler.onDecode(this.charBuffer, closed, coderResult);
        this.charBuffer.compact();
    }
}

