/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.nuprocess.codec;

import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import com.zaxxer.nuprocess.codec.NuCharsetDecoder;
import com.zaxxer.nuprocess.codec.NuCharsetDecoderHandler;
import com.zaxxer.nuprocess.codec.NuCharsetEncoder;
import com.zaxxer.nuprocess.codec.NuCharsetEncoderHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class NuAbstractCharsetHandler
implements NuProcessHandler {
    private final NuCharsetEncoder stdinEncoder;
    private final NuCharsetDecoder stdoutDecoder;
    private final NuCharsetDecoder stderrDecoder;

    protected NuAbstractCharsetHandler(Charset charset) {
        this(charset.newEncoder(), charset.newDecoder(), charset.newDecoder());
    }

    protected NuAbstractCharsetHandler(CharsetEncoder stdinEncoder, CharsetDecoder stdoutDecoder, CharsetDecoder stderrDecoder) {
        this.stdinEncoder = new NuCharsetEncoder((NuCharsetEncoderHandler)new StdinEncoderHandler(), stdinEncoder);
        this.stdoutDecoder = new NuCharsetDecoder((NuCharsetDecoderHandler)new StdoutDecoderHandler(), stdoutDecoder);
        this.stderrDecoder = new NuCharsetDecoder((NuCharsetDecoderHandler)new StderrDecoderHandler(), stderrDecoder);
    }

    protected boolean onStdinCharsReady(CharBuffer buffer) {
        return false;
    }

    protected void onStdinEncoderError(CoderResult result) {
    }

    protected void onStdoutChars(CharBuffer buffer, boolean closed, CoderResult coderResult) {
        buffer.position(buffer.limit());
    }

    protected void onStderrChars(CharBuffer buffer, boolean closed, CoderResult coderResult) {
        buffer.position(buffer.limit());
    }

    @Override
    public void onPreStart(NuProcess nuProcess) {
    }

    @Override
    public void onStart(NuProcess nuProcess) {
    }

    @Override
    public void onExit(int exitCode) {
    }

    @Override
    public final void onStdout(ByteBuffer buffer, boolean closed) {
        this.stdoutDecoder.onOutput(buffer, closed);
    }

    @Override
    public final void onStderr(ByteBuffer buffer, boolean closed) {
        this.stderrDecoder.onOutput(buffer, closed);
    }

    @Override
    public final boolean onStdinReady(ByteBuffer buffer) {
        return this.stdinEncoder.onStdinReady(buffer);
    }

    private class StderrDecoderHandler
    implements NuCharsetDecoderHandler {
        private StderrDecoderHandler() {
        }

        @Override
        public void onDecode(CharBuffer buffer, boolean closed, CoderResult decoderResult) {
            NuAbstractCharsetHandler.this.onStderrChars(buffer, closed, decoderResult);
        }
    }

    private class StdoutDecoderHandler
    implements NuCharsetDecoderHandler {
        private StdoutDecoderHandler() {
        }

        @Override
        public void onDecode(CharBuffer buffer, boolean closed, CoderResult decoderResult) {
            NuAbstractCharsetHandler.this.onStdoutChars(buffer, closed, decoderResult);
        }
    }

    private class StdinEncoderHandler
    implements NuCharsetEncoderHandler {
        private StdinEncoderHandler() {
        }

        @Override
        public boolean onStdinReady(CharBuffer buffer) {
            return NuAbstractCharsetHandler.this.onStdinCharsReady(buffer);
        }

        @Override
        public void onEncoderError(CoderResult result) {
            NuAbstractCharsetHandler.this.onStdinEncoderError(result);
        }
    }
}

