/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import jakarta.inject.Provider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.message.MessageBodyWorkers;

public abstract class ErrorEntityWriter<T, U>
implements MessageBodyWriter<T> {
    private MediaType contentType;
    private Class<U> representation;
    @Context
    private @Nullable HttpHeaders headers;
    @Context
    private @Nullable Provider<MessageBodyWorkers> mbw;

    protected ErrorEntityWriter(MediaType contentType, Class<U> representation) {
        this.contentType = contentType;
        this.representation = representation;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Objects.requireNonNull(this.headers).getAcceptableMediaTypes().contains(this.contentType);
    }

    public long getSize(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> responseHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter writer = ((MessageBodyWorkers)Objects.requireNonNull(this.mbw).get()).getMessageBodyWriter(this.representation, this.representation, annotations, this.contentType);
        responseHeaders.putSingle((Object)"Content-Type", (Object)this.contentType);
        writer.writeTo(this.getRepresentation(entity), this.representation, this.representation, annotations, this.contentType, responseHeaders, entityStream);
    }

    protected abstract U getRepresentation(T var1);
}

