/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.machines;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;

public class Features {
    public static final String CONFIG_NAME = "_features";
    public static final String BASIC = "basic";
    public static final String SIM = "sim";
    public static final String ABL = "abl";
    public static final String IBL = "ibl";
    public static final String REMAP_NOT_ALLOWED = "simMetricRemapDisabled";
    public static final String DMM = "dmm";
    public static final String RESTART = "restart";
    public static final Features DEFAULT_FEATURES = new Features((ImmutableSet<String>)ImmutableSet.of((Object)"basic"));
    public static final Features EMPTY = Features.of();
    public static final Features UNLICENSED = Features.createWithReason(Reason.access$000());
    public static final Features SIM_UNLICENSED = Features.createWithReason(Reason.access$100());
    public static final Features MA_UNLICENSED = Features.createWithReason(Reason.access$200());
    public static final Features DISABLED = Features.createWithReason(Reason.access$300());
    public static final Features EMPTY_REQUESTED = Features.createWithReason(Reason.access$400());
    public static final Features UNSUPPORTED = Features.createWithReason(Reason.access$500());
    public static final Features DOWNGRADED = Features.createWithReason("basic", Reason.access$600());
    public static final Features DOWNGRADED_ON_REMAP_NOT_ALLOWED = Features.createWithReason("basic", Reason.access$700());
    @JsonProperty
    private final ImmutableSet<String> features;
    @JsonProperty
    private final Reason reason;

    @JsonCreator
    public Features(@JsonProperty(value="features") ImmutableSet<String> features) {
        this(features, Reason.EMPTY);
    }

    public Features(ImmutableSet<String> features, Reason reason) {
        this.features = features;
        this.reason = reason;
    }

    public boolean has(String feature) {
        return this.features.contains((Object)feature);
    }

    public static Features of() {
        return new Features((ImmutableSet<String>)ImmutableSet.of());
    }

    public static Features createWithReason(Reason reason) {
        return new Features((ImmutableSet<String>)ImmutableSet.of(), reason);
    }

    public static Features createWithReason(String f1, Reason reason) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1), reason);
    }

    public static Features of(String f1) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1));
    }

    public static Features of(String f1, String f2) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1, (Object)f2));
    }

    public static Features of(String f1, String f2, String f3) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1, (Object)f2, (Object)f3));
    }

    public static Features of(String f1, String f2, String f3, String f4) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1, (Object)f2, (Object)f3, (Object)f4));
    }

    public static Features of(String f1, String f2, String f3, String f4, String f5) {
        return new Features((ImmutableSet<String>)ImmutableSet.of((Object)f1, (Object)f2, (Object)f3, (Object)f4, (Object)f5));
    }

    public static FeaturesBuilder builder() {
        return new FeaturesBuilder();
    }

    public ImmutableSet<String> getFeatures() {
        return this.features;
    }

    public Reason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Features)) {
            return false;
        }
        Features other = (Features)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableSet<String> this$features = this.getFeatures();
        ImmutableSet<String> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !this$features.equals(other$features)) {
            return false;
        }
        Reason this$reason = this.getReason();
        Reason other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Features;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableSet<String> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : $features.hashCode());
        Reason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        return result;
    }

    public String toString() {
        return "Features(features=" + this.getFeatures() + ", reason=" + this.getReason() + ")";
    }

    public static class FeaturesBuilder {
        private ImmutableSet.Builder<String> features;
        private Reason reason;

        FeaturesBuilder() {
        }

        public FeaturesBuilder feature(String feature) {
            if (this.features == null) {
                this.features = ImmutableSet.builder();
            }
            this.features.add((Object)feature);
            return this;
        }

        @JsonProperty
        public FeaturesBuilder features(Iterable<? extends String> features) {
            if (features == null) {
                throw new NullPointerException("features cannot be null");
            }
            if (this.features == null) {
                this.features = ImmutableSet.builder();
            }
            this.features.addAll(features);
            return this;
        }

        public FeaturesBuilder clearFeatures() {
            this.features = null;
            return this;
        }

        @JsonProperty
        public FeaturesBuilder reason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public Features build() {
            ImmutableSet features = this.features == null ? ImmutableSet.of() : this.features.build();
            return new Features((ImmutableSet<String>)features, this.reason);
        }

        public String toString() {
            return "Features.FeaturesBuilder(features=" + this.features + ", reason=" + this.reason + ")";
        }
    }

    public static class Reason {
        private static final String EMPTY_STRING = "";
        public static final String UNSUPPORTED_FEATURE_CODE = "Unsupported";
        public static final String EMPTY_FEATURE_CODE = "Empty";
        public static final String LICENSE_LEASE_FAILED_CODE = "License Lease Failed";
        public static final String DISABLED_AGENT_CODE = "Disabled Agent";
        public static final String SIM_DISABLED_IN_CONTROLLER_CODE = "SIM Disabled";
        private static final String REMAP_DISABLED_IN_CONTROLLER_CODE = "SIM Metric Remap Disabled";
        private static final Reason EMPTY = new Reason("", "");
        private static final Reason UNSUPPORTED_FEATURE = new Reason("Unsupported feature request from the agent", "Unsupported");
        private static final Reason EMPTY_FEATURE = new Reason("No features enabled on the agent", "Empty");
        private static final Reason LICENSE_LEASE_FAILED = new Reason("Unsuccessful leasing a license", "License Lease Failed");
        private static final Reason SIM_LICENSE_LEASE_FAILED = new Reason("Unsuccessful leasing a Server Monitoring license", "License Lease Failed");
        private static final Reason MA_LICENSE_LEASE_FAILED = new Reason("Unsuccessful leasing a Machine Agent license", "License Lease Failed");
        private static final Reason DISABLED_AGENT = new Reason("Agent is disabled", "Disabled Agent");
        private static final Reason SIM_DISABLED_IN_CONTROLLER = new Reason("SIM disabled by controller setting", "SIM Disabled");
        private static final Reason REMAP_DISABLED_IN_CONTROLLER = new Reason("SIM Metric Remap disabled by controller setting", "SIM Metric Remap Disabled");
        private final String message;
        private final String code;

        public Reason() {
            this(EMPTY_STRING, EMPTY_STRING);
        }

        public String getMessage() {
            return this.message;
        }

        public String getCode() {
            return this.code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reason)) {
                return false;
            }
            Reason other = (Reason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Reason;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        public String toString() {
            return "Features.Reason(message=" + this.getMessage() + ", code=" + this.getCode() + ")";
        }

        public Reason(String message, String code) {
            this.message = message;
            this.code = code;
        }

        static /* synthetic */ Reason access$000() {
            return LICENSE_LEASE_FAILED;
        }

        static /* synthetic */ Reason access$100() {
            return SIM_LICENSE_LEASE_FAILED;
        }

        static /* synthetic */ Reason access$200() {
            return MA_LICENSE_LEASE_FAILED;
        }

        static /* synthetic */ Reason access$300() {
            return DISABLED_AGENT;
        }

        static /* synthetic */ Reason access$400() {
            return EMPTY_FEATURE;
        }

        static /* synthetic */ Reason access$500() {
            return UNSUPPORTED_FEATURE;
        }

        static /* synthetic */ Reason access$600() {
            return SIM_DISABLED_IN_CONTROLLER;
        }

        static /* synthetic */ Reason access$700() {
            return REMAP_DISABLED_IN_CONTROLLER;
        }
    }
}

