/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.common.biz.shared.constants;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentVersion {
    private static final PatternThreadLocal AGENT_VERSION_THREADLOCAL = new PatternThreadLocal();
    private final int majorRelease;
    private final int minorRelease;
    private final int pointRelease;
    private final int agentPointRelease;

    public AgentVersion() {
        this(0, 0, 0, 0);
    }

    public AgentVersion(int major, int minor, int point, int agentPoint) {
        this.majorRelease = major;
        this.minorRelease = minor;
        this.pointRelease = point;
        this.agentPointRelease = agentPoint;
    }

    public AgentVersion(String agentVersion) {
        if (agentVersion != null) {
            Matcher matcher;
            Pattern pattern = (Pattern)AGENT_VERSION_THREADLOCAL.get();
            if (pattern == null) {
                AGENT_VERSION_THREADLOCAL.set(new PatternThreadLocal().Compile());
                pattern = (Pattern)AGENT_VERSION_THREADLOCAL.get();
            }
            if ((matcher = pattern.matcher(agentVersion)).matches()) {
                this.majorRelease = Integer.parseInt(matcher.group(2));
                this.minorRelease = Integer.parseInt(matcher.group(3));
                this.pointRelease = Integer.parseInt(matcher.group(4));
                this.agentPointRelease = Integer.parseInt(matcher.group(5));
            } else {
                this.majorRelease = 0;
                this.minorRelease = 0;
                this.pointRelease = 0;
                this.agentPointRelease = 0;
            }
        } else {
            this.majorRelease = 0;
            this.minorRelease = 0;
            this.pointRelease = 0;
            this.agentPointRelease = 0;
        }
    }

    public int getMajorRelease() {
        return this.majorRelease;
    }

    public int getMinorRelease() {
        return this.minorRelease;
    }

    public int getPointRelease() {
        return this.pointRelease;
    }

    public int getAgentPointRelease() {
        return this.agentPointRelease;
    }

    public int compareTo(AgentVersion version) {
        if (this.majorRelease > version.majorRelease) {
            return 1;
        }
        if (this.majorRelease == version.majorRelease) {
            if (this.minorRelease > version.minorRelease) {
                return 1;
            }
            if (this.minorRelease == version.minorRelease) {
                if (this.pointRelease > version.pointRelease) {
                    return 1;
                }
                if (this.pointRelease == version.pointRelease) {
                    if (this.agentPointRelease > version.agentPointRelease) {
                        return 1;
                    }
                    if (this.agentPointRelease == version.agentPointRelease) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public boolean greaterOrEqualsTo(AgentVersion version) {
        return this.compareTo(version) >= 0;
    }

    public String toString() {
        return this.majorRelease + "." + this.minorRelease + "." + this.pointRelease + "." + this.agentPointRelease;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.majorRelease;
        result = 37 * result + this.minorRelease;
        result = 37 * result + this.pointRelease;
        result = 37 * result + this.agentPointRelease;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AgentVersion) {
            AgentVersion version = (AgentVersion)obj;
            return version.majorRelease == this.majorRelease && version.minorRelease == this.minorRelease && version.pointRelease == this.pointRelease && version.agentPointRelease == this.agentPointRelease;
        }
        return false;
    }

    private static class PatternThreadLocal
    extends ThreadLocal<Pattern> {
        private PatternThreadLocal() {
        }

        @Override
        protected Pattern initialValue() {
            return Pattern.compile("(.*)([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)(.*)");
        }

        public Pattern Compile() {
            return this.initialValue();
        }
    }
}

