/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.AnnotationInclusion;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import io.dropwizard.validation.selfvalidating.SelfValidating;
import io.dropwizard.validation.selfvalidating.SelfValidation;
import io.dropwizard.validation.selfvalidating.ValidationCaller;
import io.dropwizard.validation.selfvalidating.ViolationCollector;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfValidatingValidator
implements ConstraintValidator<SelfValidating, Object> {
    private final Logger log;
    private final ConcurrentMap<Class<?>, List<ValidationCaller>> methodMap = new ConcurrentHashMap();
    private final AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration.StdConfiguration(AnnotationInclusion.INCLUDE_AND_INHERIT_IF_INHERITED);
    private final TypeResolver typeResolver = new TypeResolver();
    private final MemberResolver memberResolver = new MemberResolver(this.typeResolver);

    public SelfValidatingValidator() {
        this(LoggerFactory.getLogger(SelfValidatingValidator.class));
    }

    SelfValidatingValidator(Logger logger) {
        this.log = logger;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ViolationCollector collector = new ViolationCollector(context);
        context.disableDefaultConstraintViolation();
        for (ValidationCaller caller : this.methodMap.computeIfAbsent(value.getClass(), this::findMethods)) {
            caller.setValidationObject(value);
            caller.call(collector);
        }
        return !collector.hasViolationOccurred();
    }

    private <T> List<ValidationCaller> findMethods(Class<T> annotated) {
        ResolvedTypeWithMembers annotatedType = this.memberResolver.resolve(this.typeResolver.resolve(annotated, new Type[0]), this.annotationConfiguration, null);
        List<ValidationCaller> callers = Arrays.stream(annotatedType.getMemberMethods()).filter(this::isValidationMethod).filter(this::isMethodCorrect).map(m -> new ProxyValidationCaller(annotated, (ResolvedMethod)m)).collect(Collectors.toList());
        if (callers.isEmpty()) {
            this.log.warn("The class {} is annotated with @SelfValidating but contains no valid methods that are annotated with @SelfValidation", annotated);
        }
        return callers;
    }

    private boolean isValidationMethod(ResolvedMethod m) {
        return m.get(SelfValidation.class) != null;
    }

    boolean isMethodCorrect(ResolvedMethod m) {
        if (m.getReturnType() != null) {
            this.log.error("The method {} is annotated with @SelfValidation but does not return void. It is ignored", (Object)m.getRawMember());
            return false;
        }
        if (m.getArgumentCount() != 1 || !m.getArgumentType(0).getErasedType().equals(ViolationCollector.class)) {
            this.log.error("The method {} is annotated with @SelfValidation but does not have a single parameter of type {}", (Object)m.getRawMember(), ViolationCollector.class);
            return false;
        }
        if (!m.isPublic()) {
            this.log.error("The method {} is annotated with @SelfValidation but is not public", (Object)m.getRawMember());
            return false;
        }
        return true;
    }

    static final class ProxyValidationCaller<T>
    extends ValidationCaller<T> {
        private final Class<T> cls;
        private final ResolvedMethod resolvedMethod;

        ProxyValidationCaller(Class<T> cls, ResolvedMethod resolvedMethod) {
            this.cls = cls;
            this.resolvedMethod = resolvedMethod;
        }

        @Override
        public void call(ViolationCollector vc) {
            Method method = (Method)this.resolvedMethod.getRawMember();
            T obj = this.cls.cast(this.getValidationObject());
            try {
                method.invoke(obj, vc);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Couldn't call " + this.resolvedMethod + " on " + this.getValidationObject(), e);
            }
        }
    }
}

