/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions;

import com.appdynamics.voltron.configuration.ConfigurationClientModule;
import com.appdynamics.voltron.configuration.DynamicConfigurationClientModule;
import com.appdynamics.voltron.extensions.DefaultExtensionContext;
import com.appdynamics.voltron.extensions.DefaultExtensionsLoader;
import com.appdynamics.voltron.extensions.ExtensionConfigExecutor;
import com.appdynamics.voltron.extensions.ExtensionConfigName;
import com.appdynamics.voltron.extensions.ExtensionContext;
import com.appdynamics.voltron.extensions.ExtensionFrameworkBindingUtils;
import com.appdynamics.voltron.extensions.ExtensionLifecycleExecutor;
import com.appdynamics.voltron.extensions.ExtensionManager;
import com.appdynamics.voltron.extensions.ExtensionsConfiguration;
import com.appdynamics.voltron.extensions.ExtensionsLoader;
import com.appdynamics.voltron.utils.ManagedExecutorService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ExtensionsModule.class);
    public static final String DEFAULT_CONFIG_NAME = "extensions";
    private static final long EXTENSION_EXECUTOR_SHUTDOWN_TIMEOUT = 10000L;
    private static final long EXTENSION_CONFIG_THREADPOOL_SHUTDOWN_TIMEOUT = 10000L;
    private final String configName;
    private final boolean useDynamicConfig;

    public ExtensionsModule(@NonNull String configName, boolean useDynamicConfig) {
        if (configName == null) {
            throw new NullPointerException("configName is marked non-null but is null");
        }
        this.configName = configName;
        this.useDynamicConfig = useDynamicConfig;
    }

    public ExtensionsModule(@NonNull String configName) {
        this(configName, false);
        if (configName == null) {
            throw new NullPointerException("configName is marked non-null but is null");
        }
    }

    public ExtensionsModule() {
        this(DEFAULT_CONFIG_NAME);
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(ExtensionContext.class, DefaultExtensionContext.class).build(DefaultExtensionContext.Factory.class));
        ExtensionFrameworkBindingUtils.extensionStateListenerBinding(this.binder());
        this.bindConstant().annotatedWith(ExtensionConfigName.class).to(this.configName);
        this.bind(ExecutorService.class).annotatedWith(ExtensionLifecycleExecutor.class).to(ExtensionLifecycleExecutorService.class).in(Scopes.SINGLETON);
        this.bind(ExecutorService.class).annotatedWith(ExtensionConfigExecutor.class).to(ExtensionConfigExecutorService.class).in(Scopes.SINGLETON);
        this.bind(ExtensionsLoader.class).to(DefaultExtensionsLoader.class);
        ExtensionFrameworkBindingUtils.extensionBindingsProviderBinding(this.binder());
        this.bind(ExtensionManager.class).in(Scopes.SINGLETON);
        if (this.useDynamicConfig) {
            this.install((Module)new DynamicConfigurationClientModule(){

                protected void configureListenersAndValidators() {
                    this.bindConfigListener(ExtensionsModule.this.configName, ExtensionsConfiguration.class).to(ExtensionManager.class);
                }
            });
        } else {
            this.install((Module)new ConfigurationClientModule(){

                protected void configureListenersAndValidators() {
                    this.bindConfigListener(ExtensionsModule.this.configName, ExtensionsConfiguration.class).to(ExtensionManager.class);
                }
            });
        }
    }

    private static ExecutorService cachedSingleThreadExecutorService(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.warn("Thread " + t.getName() + " had an uncaught exception", e);
            }
        }).build());
    }

    private static class ExtensionLifecycleExecutorService
    extends ManagedExecutorService {
        private final String configName;

        @Inject
        private ExtensionLifecycleExecutorService(@ExtensionConfigName String configName) {
            this.configName = configName;
        }

        protected ExecutorService createDelegate() {
            return ExtensionsModule.cachedSingleThreadExecutorService(this.configName + "-lifecycle-threadpool");
        }

        protected TimeUnit getTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }

        protected long getShutdownTimeout() {
            return 10000L;
        }
    }

    private static class ExtensionConfigExecutorService
    extends ManagedExecutorService {
        private final String configName;

        @Inject
        private ExtensionConfigExecutorService(@ExtensionConfigName String configName) {
            this.configName = configName;
        }

        protected ExecutorService createDelegate() {
            return ExtensionsModule.cachedSingleThreadExecutorService(this.configName + "-config-threadpool");
        }

        protected TimeUnit getTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }

        protected long getShutdownTimeout() {
            return 10000L;
        }
    }
}

