/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions;

import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.extensions.DefaultExtensionContext;
import com.appdynamics.voltron.extensions.ExtensionBindingsProvider;
import com.appdynamics.voltron.extensions.ExtensionConfigExecutor;
import com.appdynamics.voltron.extensions.ExtensionContext;
import com.appdynamics.voltron.extensions.ExtensionLifecycleExecutor;
import com.appdynamics.voltron.extensions.ExtensionState;
import com.appdynamics.voltron.extensions.ExtensionStateListener;
import com.appdynamics.voltron.extensions.ExtensionsConfiguration;
import com.appdynamics.voltron.extensions.ExtensionsLoader;
import com.appdynamics.voltron.extensions.ExtensionsMonitor;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionManager
implements ConfigurationListener<ExtensionsConfiguration>,
ExtensionsMonitor {
    private static final Logger log = LoggerFactory.getLogger(ExtensionManager.class);
    private final ConcurrentMap<String, ExtensionEntry> extensionEntries;
    private final DefaultExtensionContext.Factory extensionContextFactory;
    private final ExtensionsLoader extensionsLoader;
    private final ExecutorService executorService;
    private final Object lock = new Object();
    private long maxStartTimeMillis;
    private long maxStopTimeMillis;

    @Inject
    ExtensionManager(DefaultExtensionContext.Factory extensionContextFactory, ExtensionsLoader extensionsLoader, @ExtensionConfigExecutor ExecutorService executorService, @ExtensionLifecycleExecutor ExecutorService extensionLifecycleExecutorService, Set<ExtensionBindingsProvider> bindingsProviders, Set<ExtensionStateListener> listeners) {
        this.extensionContextFactory = extensionContextFactory;
        this.extensionsLoader = extensionsLoader;
        this.executorService = executorService;
        this.extensionEntries = new ConcurrentHashMap<String, ExtensionEntry>();
        this.maxStartTimeMillis = 5000L;
        this.maxStopTimeMillis = 5000L;
    }

    public void apply(String configName, final ExtensionsConfiguration configuration) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                ExtensionManager.this.internalApply(configuration);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalApply(ExtensionsConfiguration configuration) {
        Object object = this.lock;
        synchronized (object) {
            this.maxStartTimeMillis = configuration.getMaxExtensionStartTimeMillis();
            this.maxStopTimeMillis = configuration.getMaxExtensionStopTimeMillis();
            this.removeStaleExtensions(configuration.getExtensionUrls());
            this.addNewExtensions(configuration.getExtensionUrls());
        }
    }

    private void removeStaleExtensions(Map<String, Set<URL>> newExtensionUrls) {
        Iterator iter = this.extensionEntries.entrySet().iterator();
        while (iter.hasNext()) {
            Set<URL> newUrls;
            Map.Entry entry = iter.next();
            String extName = (String)entry.getKey();
            ExtensionEntry extensionEntry = (ExtensionEntry)entry.getValue();
            Set<URL> oldUrls = extensionEntry.getExtensionUrls();
            if (oldUrls.equals(newUrls = newExtensionUrls.get(extName))) continue;
            log.debug("JAR URLs for extension '{}' have changed: {} != {}", new Object[]{extName, oldUrls, newUrls});
            ExtensionContext extensionContext = extensionEntry.getExtensionContext();
            try {
                extensionContext.stopExtension(this.maxStopTimeMillis, TimeUnit.MILLISECONDS);
                iter.remove();
            }
            catch (ExecutionException | TimeoutException e) {
                log.warn("Failed to stop extension {}.", (Object)extName);
                log.debug("Failed to stop extension {}.", (Object)extName, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private void addNewExtensions(Map<String, Set<URL>> newExtensionUrls) {
        for (Map.Entry<String, Set<URL>> urls : newExtensionUrls.entrySet()) {
            String extName = urls.getKey();
            if (this.extensionEntries.containsKey(extName)) continue;
            log.debug("Found new/updated extension '{}' with URLs: {}", (Object)extName, urls);
            Set<URL> newUrls = newExtensionUrls.get(extName);
            Collection<Module> extModules = this.extensionsLoader.loadModulesFromJars(newUrls);
            ExtensionContext extensionContext = this.extensionContextFactory.create(extName, extModules);
            try {
                ExtensionEntry entry = new ExtensionEntry(extensionContext, new HashSet<URL>(newUrls));
                this.extensionEntries.put(extName, entry);
                extensionContext.startExtension(this.maxStartTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException | ExecutionException | TimeoutException e) {
                log.debug("Failed to start extension {}.", (Object)extName, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.removeStaleExtensions(Collections.emptyMap());
        }
    }

    @Override
    public Optional<ExtensionState> getExtensionState(String extensionId) {
        ExtensionEntry entry = (ExtensionEntry)this.extensionEntries.get(extensionId);
        if (entry != null) {
            return Optional.of((Object)((Object)entry.getExtensionContext().getState()));
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listExtensionIds() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableSet(new HashSet(this.extensionEntries.keySet()));
        }
    }

    private static class ExtensionEntry {
        private final ExtensionContext extensionContext;
        private final Set<URL> extensionUrls;

        public ExtensionEntry(ExtensionContext extensionContext, Set<URL> extensionUrls) {
            this.extensionContext = extensionContext;
            this.extensionUrls = extensionUrls;
        }

        public ExtensionContext getExtensionContext() {
            return this.extensionContext;
        }

        public Set<URL> getExtensionUrls() {
            return this.extensionUrls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtensionEntry)) {
                return false;
            }
            ExtensionEntry other = (ExtensionEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExtensionContext this$extensionContext = this.getExtensionContext();
            ExtensionContext other$extensionContext = other.getExtensionContext();
            if (this$extensionContext == null ? other$extensionContext != null : !this$extensionContext.equals(other$extensionContext)) {
                return false;
            }
            Set<URL> this$extensionUrls = this.getExtensionUrls();
            Set<URL> other$extensionUrls = other.getExtensionUrls();
            return !(this$extensionUrls == null ? other$extensionUrls != null : !((Object)this$extensionUrls).equals(other$extensionUrls));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtensionEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExtensionContext $extensionContext = this.getExtensionContext();
            result = result * 59 + ($extensionContext == null ? 43 : $extensionContext.hashCode());
            Set<URL> $extensionUrls = this.getExtensionUrls();
            result = result * 59 + ($extensionUrls == null ? 43 : ((Object)$extensionUrls).hashCode());
            return result;
        }

        public String toString() {
            return "ExtensionManager.ExtensionEntry(extensionContext=" + String.valueOf(this.getExtensionContext()) + ", extensionUrls=" + String.valueOf(this.getExtensionUrls()) + ")";
        }
    }
}

