/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.extensions;

import com.appdynamics.voltron.AppLifecycleModule;
import com.appdynamics.voltron.extensions.ExtensionBindingsProvider;
import com.appdynamics.voltron.extensions.ExtensionContext;
import com.appdynamics.voltron.extensions.ExtensionLifecycleExecutor;
import com.appdynamics.voltron.extensions.ExtensionState;
import com.appdynamics.voltron.extensions.ExtensionStateListener;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExtensionContext
implements ExtensionContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultExtensionContext.class);
    private final Collection<Module> extensionModules;
    private final String extensionId;
    private final Set<ExtensionStateListener> listeners;
    private final AppLifecycleModule lifecycleModule;
    private final ExecutorService executorService;
    private volatile ExtensionState state;
    private volatile Injector extensionInjector;

    @Inject
    DefaultExtensionContext(@Assisted String extensionId, @Assisted Collection<Module> extensionModules, @ExtensionLifecycleExecutor ExecutorService executorService, Set<ExtensionBindingsProvider> bindingsProviders, Set<ExtensionStateListener> listeners) {
        this.executorService = executorService;
        this.extensionId = extensionId;
        this.listeners = listeners;
        this.extensionModules = new ArrayList<Module>(extensionModules);
        this.state = ExtensionState.NEW;
        this.lifecycleModule = new AppLifecycleModule();
        this.extensionModules.add((Module)this.lifecycleModule);
        this.extensionModules.add(new ExtraBindingsModule(extensionId, bindingsProviders));
    }

    @Override
    public synchronized void startExtension(long timeOut, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        if (this.extensionId != null && this.extensionId.equals("ServerMonitoring")) {
            log.info("Starting extension {}", (Object)this.extensionId);
        }
        if (this.state != ExtensionState.NEW) {
            String msg = "Failed to start " + this.extensionId + ". Extension is already running, being stopped, or failed.";
            throw new IllegalStateException(msg);
        }
        this.state = ExtensionState.STARTING;
        for (ExtensionStateListener extensionStateListener : this.listeners) {
            extensionStateListener.extensionStarting(this.extensionId);
        }
        Future<?> startFuture = this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                String currThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("ExtensionStarter-" + DefaultExtensionContext.this.extensionId);
                try {
                    DefaultExtensionContext.this.startExtensionInternal();
                }
                finally {
                    Thread.currentThread().setName(currThreadName);
                }
            }
        });
        try {
            if (this.extensionId != null && this.extensionId.equals("ServerMonitoring")) {
                log.info("Waiting for extension {} to start.", (Object)this.extensionId);
            }
            startFuture.get(timeOut, timeUnit);
            if (this.extensionId != null && this.extensionId.equals("ServerMonitoring")) {
                log.info("Extension {} started.", (Object)this.extensionId);
            }
            this.state = ExtensionState.STARTED;
            for (ExtensionStateListener listener : this.listeners) {
                listener.extensionStarted(this.extensionId, this.extensionInjector);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            if (!startFuture.isDone()) {
                startFuture.cancel(true);
            }
            log.debug("Extension {} failed to start.", (Object)this.extensionId);
            this.state = ExtensionState.FAILED;
            for (ExtensionStateListener listener : this.listeners) {
                listener.extensionFailed(this.extensionId, exception);
            }
            throw exception;
        }
    }

    @Override
    public synchronized void stopExtension(long timeOut, TimeUnit timeUnit) throws TimeoutException, ExecutionException, InterruptedException {
        if (this.state != ExtensionState.STARTED) {
            log.debug("Attempted to stop extension {} when in state {}. Ignoring.", (Object)this.extensionId, (Object)this.state);
        } else {
            log.debug("Stopping extension {}", (Object)this.extensionId);
            this.state = ExtensionState.STOPPING;
            for (ExtensionStateListener extensionStateListener : this.listeners) {
                extensionStateListener.extensionStopping(this.extensionId, this.extensionInjector);
            }
            Future<?> stopFuture = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    String currThreadName = Thread.currentThread().getName();
                    Thread.currentThread().setName("ExtensionStopper-" + DefaultExtensionContext.this.extensionId);
                    try {
                        DefaultExtensionContext.this.stopExtensionInternal();
                    }
                    finally {
                        Thread.currentThread().setName(currThreadName);
                    }
                }
            });
            try {
                log.debug("Waiting for extension {} to stop.", (Object)this.extensionId);
                stopFuture.get(timeOut, timeUnit);
                log.debug("Extension {} stopped.", (Object)this.extensionId);
                this.state = ExtensionState.STOPPED;
                for (ExtensionStateListener listener : this.listeners) {
                    listener.extensionStopped(this.extensionId);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                if (!stopFuture.isDone()) {
                    stopFuture.cancel(true);
                }
                log.debug("Extension {} failed to stop.", (Object)this.extensionId);
                this.state = ExtensionState.FAILED;
                for (ExtensionStateListener listener : this.listeners) {
                    listener.extensionFailed(this.extensionId, exception);
                }
                throw exception;
            }
        }
    }

    @Override
    public ExtensionState getState() {
        return this.state;
    }

    private void startExtensionInternal() {
        if (this.extensionId != null && this.extensionId.equals("ServerMonitoring")) {
            log.info("Starting up extension {} within service", (Object)this.extensionId);
        }
        this.extensionInjector = Guice.createInjector(this.extensionModules);
        log.debug("Created extension injector for {}.", (Object)this.extensionId);
    }

    private void stopExtensionInternal() {
        log.debug("Stopping extension {} within service", (Object)this.extensionId);
        this.lifecycleModule.stop();
    }

    private static class ExtraBindingsModule
    implements Module {
        private final String extensionId;
        private final Set<ExtensionBindingsProvider> bindingsProviders;

        private ExtraBindingsModule(String extensionId, Set<ExtensionBindingsProvider> bindingsProviders) {
            this.extensionId = extensionId;
            this.bindingsProviders = bindingsProviders;
        }

        public void configure(Binder binder) {
            for (ExtensionBindingsProvider provider : this.bindingsProviders) {
                provider.configure(this.extensionId, binder);
            }
        }
    }

    static interface Factory {
        public ExtensionContext create(@Assisted String var1, @Assisted Collection<Module> var2);
    }
}

