/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.netviz.api.dto.metadata;

import com.appdynamics.netviz.api.dto.metadata.FlowGroupType;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import java.text.MessageFormat;
import lombok.NonNull;

@UiCodeGen
@GenProto(protoFile="NetVizControllerConfiguration.proto")
public class FlowGroup
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private long id = -1L;
    @FieldPosition(value=3)
    @NonNull
    private String srcIP;
    @FieldPosition(value=4)
    @NonNull
    private String destIP;
    @FieldPosition(value=5)
    private long destPort;
    @FieldPosition(value=6)
    @NonNull
    private String protocol;
    @FieldPosition(value=7)
    private FlowGroupType flowGroupType;
    @FieldPosition(value=8)
    private long createdOn;
    @FieldPosition(value=9)
    private long modifiedOn;
    @FieldPosition(value=10)
    private long applicationId;

    public FlowGroup(String srcIP, String destIP, long destPort, String protocol, long applicationId) {
        this.srcIP = srcIP;
        this.destIP = destIP;
        this.destPort = destPort;
        this.protocol = protocol;
        this.applicationId = applicationId;
    }

    public String displayString() {
        String protocol = this.getProtocol();
        if (protocol.equals("6")) {
            protocol = "TCP";
        }
        return MessageFormat.format("src-{0};dst-{1};dport-{2};proto-{3}", this.getSrcIP(), this.getDestIP(), String.valueOf(this.getDestPort()), protocol);
    }

    public long getId() {
        return this.id;
    }

    @NonNull
    public String getSrcIP() {
        return this.srcIP;
    }

    @NonNull
    public String getDestIP() {
        return this.destIP;
    }

    public long getDestPort() {
        return this.destPort;
    }

    @NonNull
    public String getProtocol() {
        return this.protocol;
    }

    public FlowGroupType getFlowGroupType() {
        return this.flowGroupType;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public long getModifiedOn() {
        return this.modifiedOn;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSrcIP(@NonNull String srcIP) {
        if (srcIP == null) {
            throw new NullPointerException("srcIP");
        }
        this.srcIP = srcIP;
    }

    public void setDestIP(@NonNull String destIP) {
        if (destIP == null) {
            throw new NullPointerException("destIP");
        }
        this.destIP = destIP;
    }

    public void setDestPort(long destPort) {
        this.destPort = destPort;
    }

    public void setProtocol(@NonNull String protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        this.protocol = protocol;
    }

    public void setFlowGroupType(FlowGroupType flowGroupType) {
        this.flowGroupType = flowGroupType;
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public void setModifiedOn(long modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowGroup)) {
            return false;
        }
        FlowGroup other = (FlowGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this_srcIP = this.getSrcIP();
        String other_srcIP = other.getSrcIP();
        if (this_srcIP == null ? other_srcIP != null : !this_srcIP.equals(other_srcIP)) {
            return false;
        }
        String this_destIP = this.getDestIP();
        String other_destIP = other.getDestIP();
        if (this_destIP == null ? other_destIP != null : !this_destIP.equals(other_destIP)) {
            return false;
        }
        if (this.getDestPort() != other.getDestPort()) {
            return false;
        }
        String this_protocol = this.getProtocol();
        String other_protocol = other.getProtocol();
        if (this_protocol == null ? other_protocol != null : !this_protocol.equals(other_protocol)) {
            return false;
        }
        FlowGroupType this_flowGroupType = this.getFlowGroupType();
        FlowGroupType other_flowGroupType = other.getFlowGroupType();
        if (this_flowGroupType == null ? other_flowGroupType != null : !((Object)((Object)this_flowGroupType)).equals((Object)other_flowGroupType)) {
            return false;
        }
        return this.getApplicationId() == other.getApplicationId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String _srcIP = this.getSrcIP();
        result = result * 59 + (_srcIP == null ? 0 : _srcIP.hashCode());
        String _destIP = this.getDestIP();
        result = result * 59 + (_destIP == null ? 0 : _destIP.hashCode());
        long _destPort = this.getDestPort();
        result = result * 59 + (int)(_destPort >>> 32 ^ _destPort);
        String _protocol = this.getProtocol();
        result = result * 59 + (_protocol == null ? 0 : _protocol.hashCode());
        FlowGroupType _flowGroupType = this.getFlowGroupType();
        result = result * 59 + (_flowGroupType == null ? 0 : ((Object)((Object)_flowGroupType)).hashCode());
        long _applicationId = this.getApplicationId();
        result = result * 59 + (int)(_applicationId >>> 32 ^ _applicationId);
        return result;
    }

    public FlowGroup() {
    }

    public FlowGroup(@NonNull String srcIP, @NonNull String destIP, @NonNull String protocol) {
        if (srcIP == null) {
            throw new NullPointerException("srcIP");
        }
        if (destIP == null) {
            throw new NullPointerException("destIP");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        this.srcIP = srcIP;
        this.destIP = destIP;
        this.protocol = protocol;
    }

    public FlowGroup(long id, @NonNull String srcIP, @NonNull String destIP, long destPort, @NonNull String protocol, FlowGroupType flowGroupType, long createdOn, long modifiedOn, long applicationId) {
        if (srcIP == null) {
            throw new NullPointerException("srcIP");
        }
        if (destIP == null) {
            throw new NullPointerException("destIP");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        this.id = id;
        this.srcIP = srcIP;
        this.destIP = destIP;
        this.destPort = destPort;
        this.protocol = protocol;
        this.flowGroupType = flowGroupType;
        this.createdOn = createdOn;
        this.modifiedOn = modifiedOn;
        this.applicationId = applicationId;
    }

    public String toString() {
        return "FlowGroup(id=" + this.getId() + ", srcIP=" + this.getSrcIP() + ", destIP=" + this.getDestIP() + ", destPort=" + this.getDestPort() + ", protocol=" + this.getProtocol() + ", flowGroupType=" + (Object)((Object)this.getFlowGroupType()) + ", applicationId=" + this.getApplicationId() + ")";
    }
}

